/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelledSpotInstanceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CancelledSpotInstanceRequest> {
    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotInstanceRequestId").getter(CancelledSpotInstanceRequest.getter(CancelledSpotInstanceRequest::spotInstanceRequestId)).setter(CancelledSpotInstanceRequest.setter(Builder::spotInstanceRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("spotInstanceRequestId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CancelledSpotInstanceRequest.getter(CancelledSpotInstanceRequest::stateAsString)).setter(CancelledSpotInstanceRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_INSTANCE_REQUEST_ID_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String spotInstanceRequestId;
    private final String state;

    private CancelledSpotInstanceRequest(BuilderImpl builder) {
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.state = builder.state;
    }

    public final String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public final CancelSpotInstanceRequestState state() {
        return CancelSpotInstanceRequestState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelledSpotInstanceRequest)) {
            return false;
        }
        CancelledSpotInstanceRequest other = (CancelledSpotInstanceRequest)obj;
        return Objects.equals(this.spotInstanceRequestId(), other.spotInstanceRequestId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CancelledSpotInstanceRequest").add("SpotInstanceRequestId", (Object)this.spotInstanceRequestId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotInstanceRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelledSpotInstanceRequest, T> g) {
        return obj -> g.apply((CancelledSpotInstanceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spotInstanceRequestId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelledSpotInstanceRequest model) {
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.state(model.state);
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        @Override
        @Transient
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(CancelSpotInstanceRequestState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public CancelledSpotInstanceRequest build() {
            return new CancelledSpotInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CancelledSpotInstanceRequest> {
        public Builder spotInstanceRequestId(String var1);

        public Builder state(String var1);

        public Builder state(CancelSpotInstanceRequestState var1);
    }
}

