/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SnapshotState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotInfo> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SnapshotInfo.getter(SnapshotInfo::description)).setter(SnapshotInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SnapshotInfo.getter(SnapshotInfo::tags)).setter(SnapshotInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(SnapshotInfo.getter(SnapshotInfo::encrypted)).setter(SnapshotInfo.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(SnapshotInfo.getter(SnapshotInfo::volumeId)).setter(SnapshotInfo.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SnapshotInfo.getter(SnapshotInfo::stateAsString)).setter(SnapshotInfo.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSize").getter(SnapshotInfo.getter(SnapshotInfo::volumeSize)).setter(SnapshotInfo.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").unmarshallLocationName("volumeSize").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(SnapshotInfo.getter(SnapshotInfo::startTime)).setter(SnapshotInfo.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Progress").getter(SnapshotInfo.getter(SnapshotInfo::progress)).setter(SnapshotInfo.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SnapshotInfo.getter(SnapshotInfo::ownerId)).setter(SnapshotInfo.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(SnapshotInfo.getter(SnapshotInfo::snapshotId)).setter(SnapshotInfo.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(SnapshotInfo.getter(SnapshotInfo::outpostArn)).setter(SnapshotInfo.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, TAGS_FIELD, ENCRYPTED_FIELD, VOLUME_ID_FIELD, STATE_FIELD, VOLUME_SIZE_FIELD, START_TIME_FIELD, PROGRESS_FIELD, OWNER_ID_FIELD, SNAPSHOT_ID_FIELD, OUTPOST_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<Tag> tags;
    private final Boolean encrypted;
    private final String volumeId;
    private final String state;
    private final Integer volumeSize;
    private final Instant startTime;
    private final String progress;
    private final String ownerId;
    private final String snapshotId;
    private final String outpostArn;

    private SnapshotInfo(BuilderImpl builder) {
        this.description = builder.description;
        this.tags = builder.tags;
        this.encrypted = builder.encrypted;
        this.volumeId = builder.volumeId;
        this.state = builder.state;
        this.volumeSize = builder.volumeSize;
        this.startTime = builder.startTime;
        this.progress = builder.progress;
        this.ownerId = builder.ownerId;
        this.snapshotId = builder.snapshotId;
        this.outpostArn = builder.outpostArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final SnapshotState state() {
        return SnapshotState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer volumeSize() {
        return this.volumeSize;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String progress() {
        return this.progress;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotInfo)) {
            return false;
        }
        SnapshotInfo other = (SnapshotInfo)obj;
        return Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.outpostArn(), other.outpostArn());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotInfo").add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("Encrypted", (Object)this.encrypted()).add("VolumeId", (Object)this.volumeId()).add("State", (Object)this.stateAsString()).add("VolumeSize", (Object)this.volumeSize()).add("StartTime", (Object)this.startTime()).add("Progress", (Object)this.progress()).add("OwnerId", (Object)this.ownerId()).add("SnapshotId", (Object)this.snapshotId()).add("OutpostArn", (Object)this.outpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotInfo, T> g) {
        return obj -> g.apply((SnapshotInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean encrypted;
        private String volumeId;
        private String state;
        private Integer volumeSize;
        private Instant startTime;
        private String progress;
        private String ownerId;
        private String snapshotId;
        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotInfo model) {
            this.description(model.description);
            this.tags(model.tags);
            this.encrypted(model.encrypted);
            this.volumeId(model.volumeId);
            this.state(model.state);
            this.volumeSize(model.volumeSize);
            this.startTime(model.startTime);
            this.progress(model.progress);
            this.ownerId(model.ownerId);
            this.snapshotId(model.snapshotId);
            this.outpostArn(model.outpostArn);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        @Transient
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(SnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        @Transient
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getProgress() {
            return this.progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        @Transient
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        @Transient
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public SnapshotInfo build() {
            return new SnapshotInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotInfo> {
        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder encrypted(Boolean var1);

        public Builder volumeId(String var1);

        public Builder state(String var1);

        public Builder state(SnapshotState var1);

        public Builder volumeSize(Integer var1);

        public Builder startTime(Instant var1);

        public Builder progress(String var1);

        public Builder ownerId(String var1);

        public Builder snapshotId(String var1);

        public Builder outpostArn(String var1);
    }
}

