/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClientVpnRouteStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientVpnRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientVpnRoute> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(ClientVpnRoute.getter(ClientVpnRoute::clientVpnEndpointId)).setter(ClientVpnRoute.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("clientVpnEndpointId").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidr").getter(ClientVpnRoute.getter(ClientVpnRoute::destinationCidr)).setter(ClientVpnRoute.setter(Builder::destinationCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidr").unmarshallLocationName("destinationCidr").build()}).build();
    private static final SdkField<String> TARGET_SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetSubnet").getter(ClientVpnRoute.getter(ClientVpnRoute::targetSubnet)).setter(ClientVpnRoute.setter(Builder::targetSubnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSubnet").unmarshallLocationName("targetSubnet").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ClientVpnRoute.getter(ClientVpnRoute::type)).setter(ClientVpnRoute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(ClientVpnRoute.getter(ClientVpnRoute::origin)).setter(ClientVpnRoute.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").unmarshallLocationName("origin").build()}).build();
    private static final SdkField<ClientVpnRouteStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ClientVpnRoute.getter(ClientVpnRoute::status)).setter(ClientVpnRoute.setter(Builder::status)).constructor(ClientVpnRouteStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ClientVpnRoute.getter(ClientVpnRoute::description)).setter(ClientVpnRoute.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, DESTINATION_CIDR_FIELD, TARGET_SUBNET_FIELD, TYPE_FIELD, ORIGIN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientVpnEndpointId;
    private final String destinationCidr;
    private final String targetSubnet;
    private final String type;
    private final String origin;
    private final ClientVpnRouteStatus status;
    private final String description;

    private ClientVpnRoute(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.destinationCidr = builder.destinationCidr;
        this.targetSubnet = builder.targetSubnet;
        this.type = builder.type;
        this.origin = builder.origin;
        this.status = builder.status;
        this.description = builder.description;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final String destinationCidr() {
        return this.destinationCidr;
    }

    public final String targetSubnet() {
        return this.targetSubnet;
    }

    public final String type() {
        return this.type;
    }

    public final String origin() {
        return this.origin;
    }

    public final ClientVpnRouteStatus status() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSubnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.origin());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnRoute)) {
            return false;
        }
        ClientVpnRoute other = (ClientVpnRoute)obj;
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.destinationCidr(), other.destinationCidr()) && Objects.equals(this.targetSubnet(), other.targetSubnet()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ClientVpnRoute").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("DestinationCidr", (Object)this.destinationCidr()).add("TargetSubnet", (Object)this.targetSubnet()).add("Type", (Object)this.type()).add("Origin", (Object)this.origin()).add("Status", (Object)this.status()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "DestinationCidr": {
                return Optional.ofNullable(clazz.cast(this.destinationCidr()));
            }
            case "TargetSubnet": {
                return Optional.ofNullable(clazz.cast(this.targetSubnet()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnRoute, T> g) {
        return obj -> g.apply((ClientVpnRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String destinationCidr;
        private String targetSubnet;
        private String type;
        private String origin;
        private ClientVpnRouteStatus status;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnRoute model) {
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.destinationCidr(model.destinationCidr);
            this.targetSubnet(model.targetSubnet);
            this.type(model.type);
            this.origin(model.origin);
            this.status(model.status);
            this.description(model.description);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        @Transient
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getDestinationCidr() {
            return this.destinationCidr;
        }

        public final void setDestinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
        }

        @Override
        @Transient
        public final Builder destinationCidr(String destinationCidr) {
            this.destinationCidr = destinationCidr;
            return this;
        }

        public final String getTargetSubnet() {
            return this.targetSubnet;
        }

        public final void setTargetSubnet(String targetSubnet) {
            this.targetSubnet = targetSubnet;
        }

        @Override
        @Transient
        public final Builder targetSubnet(String targetSubnet) {
            this.targetSubnet = targetSubnet;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        @Transient
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public final ClientVpnRouteStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ClientVpnRouteStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(ClientVpnRouteStatus status) {
            this.status = status;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ClientVpnRoute build() {
            return new ClientVpnRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientVpnRoute> {
        public Builder clientVpnEndpointId(String var1);

        public Builder destinationCidr(String var1);

        public Builder targetSubnet(String var1);

        public Builder type(String var1);

        public Builder origin(String var1);

        public Builder status(ClientVpnRouteStatus var1);

        default public Builder status(Consumer<ClientVpnRouteStatus.Builder> status) {
            return this.status((ClientVpnRouteStatus)((ClientVpnRouteStatus.Builder)ClientVpnRouteStatus.builder().applyMutation(status)).build());
        }

        public Builder description(String var1);
    }
}

