/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcRequest> {
    private static final SdkField<Boolean> AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AmazonProvidedIpv6CidrBlock").getter(CreateVpcRequest.getter(CreateVpcRequest::amazonProvidedIpv6CidrBlock)).setter(CreateVpcRequest.setter(Builder::amazonProvidedIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonProvidedIpv6CidrBlock").unmarshallLocationName("amazonProvidedIpv6CidrBlock").build()}).build();
    private static final SdkField<String> IPV6_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Pool").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6Pool)).setter(CreateVpcRequest.setter(Builder::ipv6Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Pool").unmarshallLocationName("Ipv6Pool").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6CidrBlock)).setter(CreateVpcRequest.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("Ipv6CidrBlock").build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceTenancy").getter(CreateVpcRequest.getter(CreateVpcRequest::instanceTenancyAsString)).setter(CreateVpcRequest.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlockNetworkBorderGroup").getter(CreateVpcRequest.getter(CreateVpcRequest::ipv6CidrBlockNetworkBorderGroup)).setter(CreateVpcRequest.setter(Builder::ipv6CidrBlockNetworkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockNetworkBorderGroup").unmarshallLocationName("Ipv6CidrBlockNetworkBorderGroup").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVpcRequest.getter(CreateVpcRequest::tagSpecifications)).setter(CreateVpcRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(CreateVpcRequest.getter(CreateVpcRequest::cidrBlock)).setter(CreateVpcRequest.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("CidrBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_PROVIDED_IPV6_CIDR_BLOCK_FIELD, IPV6_POOL_FIELD, IPV6_CIDR_BLOCK_FIELD, INSTANCE_TENANCY_FIELD, IPV6_CIDR_BLOCK_NETWORK_BORDER_GROUP_FIELD, TAG_SPECIFICATIONS_FIELD, CIDR_BLOCK_FIELD));
    private final Boolean amazonProvidedIpv6CidrBlock;
    private final String ipv6Pool;
    private final String ipv6CidrBlock;
    private final String instanceTenancy;
    private final String ipv6CidrBlockNetworkBorderGroup;
    private final List<TagSpecification> tagSpecifications;
    private final String cidrBlock;

    private CreateVpcRequest(BuilderImpl builder) {
        super(builder);
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.ipv6Pool = builder.ipv6Pool;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockNetworkBorderGroup = builder.ipv6CidrBlockNetworkBorderGroup;
        this.tagSpecifications = builder.tagSpecifications;
        this.cidrBlock = builder.cidrBlock;
    }

    public final Boolean amazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    public final String ipv6Pool() {
        return this.ipv6Pool;
    }

    public final String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public final String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public final String ipv6CidrBlockNetworkBorderGroup() {
        return this.ipv6CidrBlockNetworkBorderGroup;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonProvidedIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockNetworkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest)((Object)obj);
        return Objects.equals(this.amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock()) && Objects.equals(this.ipv6Pool(), other.ipv6Pool()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.ipv6CidrBlockNetworkBorderGroup(), other.ipv6CidrBlockNetworkBorderGroup()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.cidrBlock(), other.cidrBlock());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcRequest").add("AmazonProvidedIpv6CidrBlock", (Object)this.amazonProvidedIpv6CidrBlock()).add("Ipv6Pool", (Object)this.ipv6Pool()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("Ipv6CidrBlockNetworkBorderGroup", (Object)this.ipv6CidrBlockNetworkBorderGroup()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("CidrBlock", (Object)this.cidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonProvidedIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.amazonProvidedIpv6CidrBlock()));
            }
            case "Ipv6Pool": {
                return Optional.ofNullable(clazz.cast(this.ipv6Pool()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
            case "Ipv6CidrBlockNetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockNetworkBorderGroup()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcRequest, T> g) {
        return obj -> g.apply((CreateVpcRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean amazonProvidedIpv6CidrBlock;
        private String ipv6Pool;
        private String ipv6CidrBlock;
        private String instanceTenancy;
        private String ipv6CidrBlockNetworkBorderGroup;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String cidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcRequest model) {
            super(model);
            this.amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            this.ipv6Pool(model.ipv6Pool);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.instanceTenancy(model.instanceTenancy);
            this.ipv6CidrBlockNetworkBorderGroup(model.ipv6CidrBlockNetworkBorderGroup);
            this.tagSpecifications(model.tagSpecifications);
            this.cidrBlock(model.cidrBlock);
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return this.amazonProvidedIpv6CidrBlock;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        @Override
        @Transient
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final String getIpv6Pool() {
            return this.ipv6Pool;
        }

        public final void setIpv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
        }

        @Override
        @Transient
        public final Builder ipv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        @Transient
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        @Transient
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final String getIpv6CidrBlockNetworkBorderGroup() {
            return this.ipv6CidrBlockNetworkBorderGroup;
        }

        public final void setIpv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
        }

        @Override
        @Transient
        public final Builder ipv6CidrBlockNetworkBorderGroup(String ipv6CidrBlockNetworkBorderGroup) {
            this.ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        @Transient
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        @Transient
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcRequest build() {
            return new CreateVpcRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcRequest> {
        public Builder amazonProvidedIpv6CidrBlock(Boolean var1);

        public Builder ipv6Pool(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder ipv6CidrBlockNetworkBorderGroup(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder cidrBlock(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

