/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway;

public class DescribeEgressOnlyInternetGatewaysPublisher
implements SdkPublisher<DescribeEgressOnlyInternetGatewaysResponse> {
    private final Ec2AsyncClient client;
    private final DescribeEgressOnlyInternetGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEgressOnlyInternetGatewaysPublisher(Ec2AsyncClient client, DescribeEgressOnlyInternetGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEgressOnlyInternetGatewaysPublisher(Ec2AsyncClient client, DescribeEgressOnlyInternetGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEgressOnlyInternetGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEgressOnlyInternetGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EgressOnlyInternetGateway> egressOnlyInternetGateways() {
        Function<DescribeEgressOnlyInternetGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.egressOnlyInternetGateways() != null) {
                return response.egressOnlyInternetGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEgressOnlyInternetGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEgressOnlyInternetGatewaysResponseFetcher
    implements AsyncPageFetcher<DescribeEgressOnlyInternetGatewaysResponse> {
        private DescribeEgressOnlyInternetGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEgressOnlyInternetGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEgressOnlyInternetGatewaysResponse> nextPage(DescribeEgressOnlyInternetGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeEgressOnlyInternetGatewaysPublisher.this.client.describeEgressOnlyInternetGateways(DescribeEgressOnlyInternetGatewaysPublisher.this.firstRequest);
            }
            return DescribeEgressOnlyInternetGatewaysPublisher.this.client.describeEgressOnlyInternetGateways((DescribeEgressOnlyInternetGatewaysRequest)((Object)DescribeEgressOnlyInternetGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

