/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeStatusEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeStatusEvent> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(VolumeStatusEvent.getter(VolumeStatusEvent::description)).setter(VolumeStatusEvent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(VolumeStatusEvent.getter(VolumeStatusEvent::eventId)).setter(VolumeStatusEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").unmarshallLocationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(VolumeStatusEvent.getter(VolumeStatusEvent::eventType)).setter(VolumeStatusEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").unmarshallLocationName("eventType").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotAfter").getter(VolumeStatusEvent.getter(VolumeStatusEvent::notAfter)).setter(VolumeStatusEvent.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").unmarshallLocationName("notAfter").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotBefore").getter(VolumeStatusEvent.getter(VolumeStatusEvent::notBefore)).setter(VolumeStatusEvent.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").unmarshallLocationName("notBefore").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(VolumeStatusEvent.getter(VolumeStatusEvent::instanceId)).setter(VolumeStatusEvent.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EVENT_ID_FIELD, EVENT_TYPE_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD, INSTANCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String eventId;
    private final String eventType;
    private final Instant notAfter;
    private final Instant notBefore;
    private final String instanceId;

    private VolumeStatusEvent(BuilderImpl builder) {
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
        this.instanceId = builder.instanceId;
    }

    public final String description() {
        return this.description;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final Instant notAfter() {
        return this.notAfter;
    }

    public final Instant notBefore() {
        return this.notBefore;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusEvent)) {
            return false;
        }
        VolumeStatusEvent other = (VolumeStatusEvent)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeStatusEvent").add("Description", (Object)this.description()).add("EventId", (Object)this.eventId()).add("EventType", (Object)this.eventType()).add("NotAfter", (Object)this.notAfter()).add("NotBefore", (Object)this.notBefore()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "NotBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusEvent, T> g) {
        return obj -> g.apply((VolumeStatusEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String eventId;
        private String eventType;
        private Instant notAfter;
        private Instant notBefore;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusEvent model) {
            this.description(model.description);
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.notAfter(model.notAfter);
            this.notBefore(model.notBefore);
            this.instanceId(model.instanceId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public VolumeStatusEvent build() {
            return new VolumeStatusEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeStatusEvent> {
        public Builder description(String var1);

        public Builder eventId(String var1);

        public Builder eventType(String var1);

        public Builder notAfter(Instant var1);

        public Builder notBefore(Instant var1);

        public Builder instanceId(String var1);
    }
}

