/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceleratorName {
    A100("a100"),
    V100("v100"),
    K80("k80"),
    T4("t4"),
    M60("m60"),
    RADEON_PRO_V520("radeon-pro-v520"),
    VU9_P("vu9p"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceleratorName> VALUE_MAP;
    private final String value;

    private AcceleratorName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceleratorName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceleratorName> knownValues() {
        EnumSet<AcceleratorName> knownValues = EnumSet.allOf(AcceleratorName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceleratorName.class, AcceleratorName::toString);
    }
}

