/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.VolumeModification;

public class DescribeVolumesModificationsIterable
implements SdkIterable<DescribeVolumesModificationsResponse> {
    private final Ec2Client client;
    private final DescribeVolumesModificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVolumesModificationsIterable(Ec2Client client, DescribeVolumesModificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVolumesModificationsResponseFetcher();
    }

    public Iterator<DescribeVolumesModificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VolumeModification> volumesModifications() {
        Function<DescribeVolumesModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumesModifications() != null) {
                return response.volumesModifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVolumesModificationsResponseFetcher
    implements SyncPageFetcher<DescribeVolumesModificationsResponse> {
        private DescribeVolumesModificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVolumesModificationsResponse nextPage(DescribeVolumesModificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesModificationsIterable.this.client.describeVolumesModifications(DescribeVolumesModificationsIterable.this.firstRequest);
            }
            return DescribeVolumesModificationsIterable.this.client.describeVolumesModifications((DescribeVolumesModificationsRequest)((Object)DescribeVolumesModificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

