/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.BootModeValues;
import software.amazon.awssdk.services.ec2.model.CapacityReservationSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.CpuOptions;
import software.amazon.awssdk.services.ec2.model.DeviceType;
import software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation;
import software.amazon.awssdk.services.ec2.model.ElasticGpuAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation;
import software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.EnclaveOptions;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.HibernationOptions;
import software.amazon.awssdk.services.ec2.model.HypervisorType;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceLifecycleType;
import software.amazon.awssdk.services.ec2.model.InstanceMaintenanceOptions;
import software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.LicenseConfiguration;
import software.amazon.awssdk.services.ec2.model.LicenseListCopier;
import software.amazon.awssdk.services.ec2.model.Monitoring;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.services.ec2.model.StateReason;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VirtualizationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<Integer> AMI_LAUNCH_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AmiLaunchIndex").getter(Instance.getter(Instance::amiLaunchIndex)).setter(Instance.setter(Builder::amiLaunchIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiLaunchIndex").unmarshallLocationName("amiLaunchIndex").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(Instance.getter(Instance::imageId)).setter(Instance.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(Instance.getter(Instance::instanceId)).setter(Instance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(Instance.getter(Instance::instanceTypeAsString)).setter(Instance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(Instance.getter(Instance::kernelId)).setter(Instance.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("kernelId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(Instance.getter(Instance::keyName)).setter(Instance.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(Instance.getter(Instance::launchTime)).setter(Instance.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").unmarshallLocationName("launchTime").build()}).build();
    private static final SdkField<Monitoring> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(Instance.getter(Instance::monitoring)).setter(Instance.setter(Builder::monitoring)).constructor(Monitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("monitoring").build()}).build();
    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(Instance.getter(Instance::placement)).setter(Instance.setter(Builder::placement)).constructor(Placement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("placement").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(Instance.getter(Instance::platformAsString)).setter(Instance.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(Instance.getter(Instance::privateDnsName)).setter(Instance.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(Instance.getter(Instance::privateIpAddress)).setter(Instance.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(Instance.getter(Instance::productCodes)).setter(Instance.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicDnsName").getter(Instance.getter(Instance::publicDnsName)).setter(Instance.setter(Builder::publicDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").unmarshallLocationName("dnsName").build()}).build();
    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpAddress").getter(Instance.getter(Instance::publicIpAddress)).setter(Instance.setter(Builder::publicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").unmarshallLocationName("ipAddress").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(Instance.getter(Instance::ramdiskId)).setter(Instance.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").unmarshallLocationName("ramdiskId").build()}).build();
    private static final SdkField<InstanceState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("State").getter(Instance.getter(Instance::state)).setter(Instance.setter(Builder::state)).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState").unmarshallLocationName("instanceState").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateTransitionReason").getter(Instance.getter(Instance::stateTransitionReason)).setter(Instance.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").unmarshallLocationName("reason").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(Instance.getter(Instance::subnetId)).setter(Instance.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Instance.getter(Instance::vpcId)).setter(Instance.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(Instance.getter(Instance::architectureAsString)).setter(Instance.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").unmarshallLocationName("architecture").build()}).build();
    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(Instance.getter(Instance::blockDeviceMappings)).setter(Instance.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceBlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(Instance.getter(Instance::clientToken)).setter(Instance.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(Instance.getter(Instance::ebsOptimized)).setter(Instance.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnaSupport").getter(Instance.getter(Instance::enaSupport)).setter(Instance.setter(Builder::enaSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport").unmarshallLocationName("enaSupport").build()}).build();
    private static final SdkField<String> HYPERVISOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hypervisor").getter(Instance.getter(Instance::hypervisorAsString)).setter(Instance.setter(Builder::hypervisor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor").unmarshallLocationName("hypervisor").build()}).build();
    private static final SdkField<IamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(Instance.getter(Instance::iamInstanceProfile)).setter(Instance.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("iamInstanceProfile").build()}).build();
    private static final SdkField<String> INSTANCE_LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceLifecycle").getter(Instance.getter(Instance::instanceLifecycleAsString)).setter(Instance.setter(Builder::instanceLifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLifecycle").unmarshallLocationName("instanceLifecycle").build()}).build();
    private static final SdkField<List<ElasticGpuAssociation>> ELASTIC_GPU_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticGpuAssociations").getter(Instance.getter(Instance::elasticGpuAssociations)).setter(Instance.setter(Builder::elasticGpuAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuAssociationSet").unmarshallLocationName("elasticGpuAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticGpuAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ElasticInferenceAcceleratorAssociation>> ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticInferenceAcceleratorAssociations").getter(Instance.getter(Instance::elasticInferenceAcceleratorAssociations)).setter(Instance.setter(Builder::elasticInferenceAcceleratorAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAcceleratorAssociationSet").unmarshallLocationName("elasticInferenceAcceleratorAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticInferenceAcceleratorAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceNetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(Instance.getter(Instance::networkInterfaces)).setter(Instance.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet").unmarshallLocationName("networkInterfaceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceNetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(Instance.getter(Instance::outpostArn)).setter(Instance.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootDeviceName").getter(Instance.getter(Instance::rootDeviceName)).setter(Instance.setter(Builder::rootDeviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName").unmarshallLocationName("rootDeviceName").build()}).build();
    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootDeviceType").getter(Instance.getter(Instance::rootDeviceTypeAsString)).setter(Instance.setter(Builder::rootDeviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType").unmarshallLocationName("rootDeviceType").build()}).build();
    private static final SdkField<List<GroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(Instance.getter(Instance::securityGroups)).setter(Instance.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SourceDestCheck").getter(Instance.getter(Instance::sourceDestCheck)).setter(Instance.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotInstanceRequestId").getter(Instance.getter(Instance::spotInstanceRequestId)).setter(Instance.setter(Builder::spotInstanceRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("spotInstanceRequestId").build()}).build();
    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SriovNetSupport").getter(Instance.getter(Instance::sriovNetSupport)).setter(Instance.setter(Builder::sriovNetSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport").unmarshallLocationName("sriovNetSupport").build()}).build();
    private static final SdkField<StateReason> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateReason").getter(Instance.getter(Instance::stateReason)).setter(Instance.setter(Builder::stateReason)).constructor(StateReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").unmarshallLocationName("stateReason").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Instance.getter(Instance::tags)).setter(Instance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VirtualizationType").getter(Instance.getter(Instance::virtualizationTypeAsString)).setter(Instance.setter(Builder::virtualizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").unmarshallLocationName("virtualizationType").build()}).build();
    private static final SdkField<CpuOptions> CPU_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CpuOptions").getter(Instance.getter(Instance::cpuOptions)).setter(Instance.setter(Builder::cpuOptions)).constructor(CpuOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").unmarshallLocationName("cpuOptions").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(Instance.getter(Instance::capacityReservationId)).setter(Instance.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("capacityReservationId").build()}).build();
    private static final SdkField<CapacityReservationSpecificationResponse> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationSpecification").getter(Instance.getter(Instance::capacityReservationSpecification)).setter(Instance.setter(Builder::capacityReservationSpecification)).constructor(CapacityReservationSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").unmarshallLocationName("capacityReservationSpecification").build()}).build();
    private static final SdkField<HibernationOptions> HIBERNATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HibernationOptions").getter(Instance.getter(Instance::hibernationOptions)).setter(Instance.setter(Builder::hibernationOptions)).constructor(HibernationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").unmarshallLocationName("hibernationOptions").build()}).build();
    private static final SdkField<List<LicenseConfiguration>> LICENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Licenses").getter(Instance.getter(Instance::licenses)).setter(Instance.setter(Builder::licenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSet").unmarshallLocationName("licenseSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<InstanceMetadataOptionsResponse> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataOptions").getter(Instance.getter(Instance::metadataOptions)).setter(Instance.setter(Builder::metadataOptions)).constructor(InstanceMetadataOptionsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").unmarshallLocationName("metadataOptions").build()}).build();
    private static final SdkField<EnclaveOptions> ENCLAVE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnclaveOptions").getter(Instance.getter(Instance::enclaveOptions)).setter(Instance.setter(Builder::enclaveOptions)).constructor(EnclaveOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").unmarshallLocationName("enclaveOptions").build()}).build();
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BootMode").getter(Instance.getter(Instance::bootModeAsString)).setter(Instance.setter(Builder::bootMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode").unmarshallLocationName("bootMode").build()}).build();
    private static final SdkField<String> PLATFORM_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformDetails").getter(Instance.getter(Instance::platformDetails)).setter(Instance.setter(Builder::platformDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDetails").unmarshallLocationName("platformDetails").build()}).build();
    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageOperation").getter(Instance.getter(Instance::usageOperation)).setter(Instance.setter(Builder::usageOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").unmarshallLocationName("usageOperation").build()}).build();
    private static final SdkField<Instant> USAGE_OPERATION_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UsageOperationUpdateTime").getter(Instance.getter(Instance::usageOperationUpdateTime)).setter(Instance.setter(Builder::usageOperationUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperationUpdateTime").unmarshallLocationName("usageOperationUpdateTime").build()}).build();
    private static final SdkField<PrivateDnsNameOptionsResponse> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateDnsNameOptions").getter(Instance.getter(Instance::privateDnsNameOptions)).setter(Instance.setter(Builder::privateDnsNameOptions)).constructor(PrivateDnsNameOptionsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions").unmarshallLocationName("privateDnsNameOptions").build()}).build();
    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Address").getter(Instance.getter(Instance::ipv6Address)).setter(Instance.setter(Builder::ipv6Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Address").unmarshallLocationName("ipv6Address").build()}).build();
    private static final SdkField<String> TPM_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TpmSupport").getter(Instance.getter(Instance::tpmSupport)).setter(Instance.setter(Builder::tpmSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TpmSupport").unmarshallLocationName("tpmSupport").build()}).build();
    private static final SdkField<InstanceMaintenanceOptions> MAINTENANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceOptions").getter(Instance.getter(Instance::maintenanceOptions)).setter(Instance.setter(Builder::maintenanceOptions)).constructor(InstanceMaintenanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions").unmarshallLocationName("maintenanceOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_LAUNCH_INDEX_FIELD, IMAGE_ID_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, LAUNCH_TIME_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, PLATFORM_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRODUCT_CODES_FIELD, PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_ADDRESS_FIELD, RAMDISK_ID_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, ARCHITECTURE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, CLIENT_TOKEN_FIELD, EBS_OPTIMIZED_FIELD, ENA_SUPPORT_FIELD, HYPERVISOR_FIELD, IAM_INSTANCE_PROFILE_FIELD, INSTANCE_LIFECYCLE_FIELD, ELASTIC_GPU_ASSOCIATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATOR_ASSOCIATIONS_FIELD, NETWORK_INTERFACES_FIELD, OUTPOST_ARN_FIELD, ROOT_DEVICE_NAME_FIELD, ROOT_DEVICE_TYPE_FIELD, SECURITY_GROUPS_FIELD, SOURCE_DEST_CHECK_FIELD, SPOT_INSTANCE_REQUEST_ID_FIELD, SRIOV_NET_SUPPORT_FIELD, STATE_REASON_FIELD, TAGS_FIELD, VIRTUALIZATION_TYPE_FIELD, CPU_OPTIONS_FIELD, CAPACITY_RESERVATION_ID_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD, HIBERNATION_OPTIONS_FIELD, LICENSES_FIELD, METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD, BOOT_MODE_FIELD, PLATFORM_DETAILS_FIELD, USAGE_OPERATION_FIELD, USAGE_OPERATION_UPDATE_TIME_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD, IPV6_ADDRESS_FIELD, TPM_SUPPORT_FIELD, MAINTENANCE_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer amiLaunchIndex;
    private final String imageId;
    private final String instanceId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final Instant launchTime;
    private final Monitoring monitoring;
    private final Placement placement;
    private final String platform;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<ProductCode> productCodes;
    private final String publicDnsName;
    private final String publicIpAddress;
    private final String ramdiskId;
    private final InstanceState state;
    private final String stateTransitionReason;
    private final String subnetId;
    private final String vpcId;
    private final String architecture;
    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private final String clientToken;
    private final Boolean ebsOptimized;
    private final Boolean enaSupport;
    private final String hypervisor;
    private final IamInstanceProfile iamInstanceProfile;
    private final String instanceLifecycle;
    private final List<ElasticGpuAssociation> elasticGpuAssociations;
    private final List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations;
    private final List<InstanceNetworkInterface> networkInterfaces;
    private final String outpostArn;
    private final String rootDeviceName;
    private final String rootDeviceType;
    private final List<GroupIdentifier> securityGroups;
    private final Boolean sourceDestCheck;
    private final String spotInstanceRequestId;
    private final String sriovNetSupport;
    private final StateReason stateReason;
    private final List<Tag> tags;
    private final String virtualizationType;
    private final CpuOptions cpuOptions;
    private final String capacityReservationId;
    private final CapacityReservationSpecificationResponse capacityReservationSpecification;
    private final HibernationOptions hibernationOptions;
    private final List<LicenseConfiguration> licenses;
    private final InstanceMetadataOptionsResponse metadataOptions;
    private final EnclaveOptions enclaveOptions;
    private final String bootMode;
    private final String platformDetails;
    private final String usageOperation;
    private final Instant usageOperationUpdateTime;
    private final PrivateDnsNameOptionsResponse privateDnsNameOptions;
    private final String ipv6Address;
    private final String tpmSupport;
    private final InstanceMaintenanceOptions maintenanceOptions;

    private Instance(BuilderImpl builder) {
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.launchTime = builder.launchTime;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.platform = builder.platform;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.productCodes = builder.productCodes;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.clientToken = builder.clientToken;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceLifecycle = builder.instanceLifecycle;
        this.elasticGpuAssociations = builder.elasticGpuAssociations;
        this.elasticInferenceAcceleratorAssociations = builder.elasticInferenceAcceleratorAssociations;
        this.networkInterfaces = builder.networkInterfaces;
        this.outpostArn = builder.outpostArn;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationId = builder.capacityReservationId;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.hibernationOptions = builder.hibernationOptions;
        this.licenses = builder.licenses;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
        this.bootMode = builder.bootMode;
        this.platformDetails = builder.platformDetails;
        this.usageOperation = builder.usageOperation;
        this.usageOperationUpdateTime = builder.usageOperationUpdateTime;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.ipv6Address = builder.ipv6Address;
        this.tpmSupport = builder.tpmSupport;
        this.maintenanceOptions = builder.maintenanceOptions;
    }

    public final Integer amiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final Monitoring monitoring() {
        return this.monitoring;
    }

    public final Placement placement() {
        return this.placement;
    }

    public final PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public final String publicDnsName() {
        return this.publicDnsName;
    }

    public final String publicIpAddress() {
        return this.publicIpAddress;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final InstanceState state() {
        return this.state;
    }

    public final String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(this.architecture);
    }

    public final String architectureAsString() {
        return this.architecture;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final Boolean enaSupport() {
        return this.enaSupport;
    }

    public final HypervisorType hypervisor() {
        return HypervisorType.fromValue(this.hypervisor);
    }

    public final String hypervisorAsString() {
        return this.hypervisor;
    }

    public final IamInstanceProfile iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final InstanceLifecycleType instanceLifecycle() {
        return InstanceLifecycleType.fromValue(this.instanceLifecycle);
    }

    public final String instanceLifecycleAsString() {
        return this.instanceLifecycle;
    }

    public final boolean hasElasticGpuAssociations() {
        return this.elasticGpuAssociations != null && !(this.elasticGpuAssociations instanceof SdkAutoConstructList);
    }

    public final List<ElasticGpuAssociation> elasticGpuAssociations() {
        return this.elasticGpuAssociations;
    }

    public final boolean hasElasticInferenceAcceleratorAssociations() {
        return this.elasticInferenceAcceleratorAssociations != null && !(this.elasticInferenceAcceleratorAssociations instanceof SdkAutoConstructList);
    }

    public final List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations() {
        return this.elasticInferenceAcceleratorAssociations;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<InstanceNetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String rootDeviceName() {
        return this.rootDeviceName;
    }

    public final DeviceType rootDeviceType() {
        return DeviceType.fromValue(this.rootDeviceType);
    }

    public final String rootDeviceTypeAsString() {
        return this.rootDeviceType;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<GroupIdentifier> securityGroups() {
        return this.securityGroups;
    }

    public final Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public final String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public final String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public final StateReason stateReason() {
        return this.stateReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(this.virtualizationType);
    }

    public final String virtualizationTypeAsString() {
        return this.virtualizationType;
    }

    public final CpuOptions cpuOptions() {
        return this.cpuOptions;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final CapacityReservationSpecificationResponse capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    public final HibernationOptions hibernationOptions() {
        return this.hibernationOptions;
    }

    public final boolean hasLicenses() {
        return this.licenses != null && !(this.licenses instanceof SdkAutoConstructList);
    }

    public final List<LicenseConfiguration> licenses() {
        return this.licenses;
    }

    public final InstanceMetadataOptionsResponse metadataOptions() {
        return this.metadataOptions;
    }

    public final EnclaveOptions enclaveOptions() {
        return this.enclaveOptions;
    }

    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(this.bootMode);
    }

    public final String bootModeAsString() {
        return this.bootMode;
    }

    public final String platformDetails() {
        return this.platformDetails;
    }

    public final String usageOperation() {
        return this.usageOperation;
    }

    public final Instant usageOperationUpdateTime() {
        return this.usageOperationUpdateTime;
    }

    public final PrivateDnsNameOptionsResponse privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }

    public final String ipv6Address() {
        return this.ipv6Address;
    }

    public final String tpmSupport() {
        return this.tpmSupport;
    }

    public final InstanceMaintenanceOptions maintenanceOptions() {
        return this.maintenanceOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amiLaunchIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceLifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticGpuAssociations() ? this.elasticGpuAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticInferenceAcceleratorAssociations() ? this.elasticInferenceAcceleratorAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenses() ? this.licenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOperationUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(this.tpmSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.amiLaunchIndex(), other.amiLaunchIndex()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.publicDnsName(), other.publicDnsName()) && Objects.equals(this.publicIpAddress(), other.publicIpAddress()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.architectureAsString(), other.architectureAsString()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.hypervisorAsString(), other.hypervisorAsString()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.instanceLifecycleAsString(), other.instanceLifecycleAsString()) && this.hasElasticGpuAssociations() == other.hasElasticGpuAssociations() && Objects.equals(this.elasticGpuAssociations(), other.elasticGpuAssociations()) && this.hasElasticInferenceAcceleratorAssociations() == other.hasElasticInferenceAcceleratorAssociations() && Objects.equals(this.elasticInferenceAcceleratorAssociations(), other.elasticInferenceAcceleratorAssociations()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.rootDeviceName(), other.rootDeviceName()) && Objects.equals(this.rootDeviceTypeAsString(), other.rootDeviceTypeAsString()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.spotInstanceRequestId(), other.spotInstanceRequestId()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.stateReason(), other.stateReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.virtualizationTypeAsString(), other.virtualizationTypeAsString()) && Objects.equals(this.cpuOptions(), other.cpuOptions()) && Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification()) && Objects.equals(this.hibernationOptions(), other.hibernationOptions()) && this.hasLicenses() == other.hasLicenses() && Objects.equals(this.licenses(), other.licenses()) && Objects.equals(this.metadataOptions(), other.metadataOptions()) && Objects.equals(this.enclaveOptions(), other.enclaveOptions()) && Objects.equals(this.bootModeAsString(), other.bootModeAsString()) && Objects.equals(this.platformDetails(), other.platformDetails()) && Objects.equals(this.usageOperation(), other.usageOperation()) && Objects.equals(this.usageOperationUpdateTime(), other.usageOperationUpdateTime()) && Objects.equals(this.privateDnsNameOptions(), other.privateDnsNameOptions()) && Objects.equals(this.ipv6Address(), other.ipv6Address()) && Objects.equals(this.tpmSupport(), other.tpmSupport()) && Objects.equals(this.maintenanceOptions(), other.maintenanceOptions());
    }

    public final String toString() {
        return ToString.builder((String)"Instance").add("AmiLaunchIndex", (Object)this.amiLaunchIndex()).add("ImageId", (Object)this.imageId()).add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("LaunchTime", (Object)this.launchTime()).add("Monitoring", (Object)this.monitoring()).add("Placement", (Object)this.placement()).add("Platform", (Object)this.platformAsString()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("PublicDnsName", (Object)this.publicDnsName()).add("PublicIpAddress", (Object)this.publicIpAddress()).add("RamdiskId", (Object)this.ramdiskId()).add("State", (Object)this.state()).add("StateTransitionReason", (Object)this.stateTransitionReason()).add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("Architecture", (Object)this.architectureAsString()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("ClientToken", (Object)this.clientToken()).add("EbsOptimized", (Object)this.ebsOptimized()).add("EnaSupport", (Object)this.enaSupport()).add("Hypervisor", (Object)this.hypervisorAsString()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("InstanceLifecycle", (Object)this.instanceLifecycleAsString()).add("ElasticGpuAssociations", this.hasElasticGpuAssociations() ? this.elasticGpuAssociations() : null).add("ElasticInferenceAcceleratorAssociations", this.hasElasticInferenceAcceleratorAssociations() ? this.elasticInferenceAcceleratorAssociations() : null).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("OutpostArn", (Object)this.outpostArn()).add("RootDeviceName", (Object)this.rootDeviceName()).add("RootDeviceType", (Object)this.rootDeviceTypeAsString()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("SpotInstanceRequestId", (Object)this.spotInstanceRequestId()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("StateReason", (Object)this.stateReason()).add("Tags", this.hasTags() ? this.tags() : null).add("VirtualizationType", (Object)this.virtualizationTypeAsString()).add("CpuOptions", (Object)this.cpuOptions()).add("CapacityReservationId", (Object)this.capacityReservationId()).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).add("HibernationOptions", (Object)this.hibernationOptions()).add("Licenses", this.hasLicenses() ? this.licenses() : null).add("MetadataOptions", (Object)this.metadataOptions()).add("EnclaveOptions", (Object)this.enclaveOptions()).add("BootMode", (Object)this.bootModeAsString()).add("PlatformDetails", (Object)this.platformDetails()).add("UsageOperation", (Object)this.usageOperation()).add("UsageOperationUpdateTime", (Object)this.usageOperationUpdateTime()).add("PrivateDnsNameOptions", (Object)this.privateDnsNameOptions()).add("Ipv6Address", (Object)this.ipv6Address()).add("TpmSupport", (Object)this.tpmSupport()).add("MaintenanceOptions", (Object)this.maintenanceOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmiLaunchIndex": {
                return Optional.ofNullable(clazz.cast(this.amiLaunchIndex()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "PublicDnsName": {
                return Optional.ofNullable(clazz.cast(this.publicDnsName()));
            }
            case "PublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.publicIpAddress()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupport()));
            }
            case "Hypervisor": {
                return Optional.ofNullable(clazz.cast(this.hypervisorAsString()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "InstanceLifecycle": {
                return Optional.ofNullable(clazz.cast(this.instanceLifecycleAsString()));
            }
            case "ElasticGpuAssociations": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuAssociations()));
            }
            case "ElasticInferenceAcceleratorAssociations": {
                return Optional.ofNullable(clazz.cast(this.elasticInferenceAcceleratorAssociations()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "RootDeviceName": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceName()));
            }
            case "RootDeviceType": {
                return Optional.ofNullable(clazz.cast(this.rootDeviceTypeAsString()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "SpotInstanceRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestId()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VirtualizationType": {
                return Optional.ofNullable(clazz.cast(this.virtualizationTypeAsString()));
            }
            case "CpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
            case "HibernationOptions": {
                return Optional.ofNullable(clazz.cast(this.hibernationOptions()));
            }
            case "Licenses": {
                return Optional.ofNullable(clazz.cast(this.licenses()));
            }
            case "MetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
            case "EnclaveOptions": {
                return Optional.ofNullable(clazz.cast(this.enclaveOptions()));
            }
            case "BootMode": {
                return Optional.ofNullable(clazz.cast(this.bootModeAsString()));
            }
            case "PlatformDetails": {
                return Optional.ofNullable(clazz.cast(this.platformDetails()));
            }
            case "UsageOperation": {
                return Optional.ofNullable(clazz.cast(this.usageOperation()));
            }
            case "UsageOperationUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.usageOperationUpdateTime()));
            }
            case "PrivateDnsNameOptions": {
                return Optional.ofNullable(clazz.cast(this.privateDnsNameOptions()));
            }
            case "Ipv6Address": {
                return Optional.ofNullable(clazz.cast(this.ipv6Address()));
            }
            case "TpmSupport": {
                return Optional.ofNullable(clazz.cast(this.tpmSupport()));
            }
            case "MaintenanceOptions": {
                return Optional.ofNullable(clazz.cast(this.maintenanceOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer amiLaunchIndex;
        private String imageId;
        private String instanceId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private Instant launchTime;
        private Monitoring monitoring;
        private Placement placement;
        private String platform;
        private String privateDnsName;
        private String privateIpAddress;
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private String publicDnsName;
        private String publicIpAddress;
        private String ramdiskId;
        private InstanceState state;
        private String stateTransitionReason;
        private String subnetId;
        private String vpcId;
        private String architecture;
        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Boolean ebsOptimized;
        private Boolean enaSupport;
        private String hypervisor;
        private IamInstanceProfile iamInstanceProfile;
        private String instanceLifecycle;
        private List<ElasticGpuAssociation> elasticGpuAssociations = DefaultSdkAutoConstructList.getInstance();
        private List<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceNetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String outpostArn;
        private String rootDeviceName;
        private String rootDeviceType;
        private List<GroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean sourceDestCheck;
        private String spotInstanceRequestId;
        private String sriovNetSupport;
        private StateReason stateReason;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String virtualizationType;
        private CpuOptions cpuOptions;
        private String capacityReservationId;
        private CapacityReservationSpecificationResponse capacityReservationSpecification;
        private HibernationOptions hibernationOptions;
        private List<LicenseConfiguration> licenses = DefaultSdkAutoConstructList.getInstance();
        private InstanceMetadataOptionsResponse metadataOptions;
        private EnclaveOptions enclaveOptions;
        private String bootMode;
        private String platformDetails;
        private String usageOperation;
        private Instant usageOperationUpdateTime;
        private PrivateDnsNameOptionsResponse privateDnsNameOptions;
        private String ipv6Address;
        private String tpmSupport;
        private InstanceMaintenanceOptions maintenanceOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.amiLaunchIndex(model.amiLaunchIndex);
            this.imageId(model.imageId);
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.launchTime(model.launchTime);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.platform(model.platform);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.productCodes(model.productCodes);
            this.publicDnsName(model.publicDnsName);
            this.publicIpAddress(model.publicIpAddress);
            this.ramdiskId(model.ramdiskId);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.architecture(model.architecture);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.clientToken(model.clientToken);
            this.ebsOptimized(model.ebsOptimized);
            this.enaSupport(model.enaSupport);
            this.hypervisor(model.hypervisor);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.instanceLifecycle(model.instanceLifecycle);
            this.elasticGpuAssociations(model.elasticGpuAssociations);
            this.elasticInferenceAcceleratorAssociations(model.elasticInferenceAcceleratorAssociations);
            this.networkInterfaces(model.networkInterfaces);
            this.outpostArn(model.outpostArn);
            this.rootDeviceName(model.rootDeviceName);
            this.rootDeviceType(model.rootDeviceType);
            this.securityGroups(model.securityGroups);
            this.sourceDestCheck(model.sourceDestCheck);
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.sriovNetSupport(model.sriovNetSupport);
            this.stateReason(model.stateReason);
            this.tags(model.tags);
            this.virtualizationType(model.virtualizationType);
            this.cpuOptions(model.cpuOptions);
            this.capacityReservationId(model.capacityReservationId);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
            this.hibernationOptions(model.hibernationOptions);
            this.licenses(model.licenses);
            this.metadataOptions(model.metadataOptions);
            this.enclaveOptions(model.enclaveOptions);
            this.bootMode(model.bootMode);
            this.platformDetails(model.platformDetails);
            this.usageOperation(model.usageOperation);
            this.usageOperationUpdateTime(model.usageOperationUpdateTime);
            this.privateDnsNameOptions(model.privateDnsNameOptions);
            this.ipv6Address(model.ipv6Address);
            this.tpmSupport(model.tpmSupport);
            this.maintenanceOptions(model.maintenanceOptions);
        }

        public final Integer getAmiLaunchIndex() {
            return this.amiLaunchIndex;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final Monitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        public final void setMonitoring(Monitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final InstanceState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final List<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMapping.Builder> result = InstanceBlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (InstanceBlockDeviceMapping)((InstanceBlockDeviceMapping.Builder)InstanceBlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor == null ? null : hypervisor.toString());
            return this;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getInstanceLifecycle() {
            return this.instanceLifecycle;
        }

        public final void setInstanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
        }

        @Override
        public final Builder instanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
            return this;
        }

        @Override
        public final Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle) {
            this.instanceLifecycle(instanceLifecycle == null ? null : instanceLifecycle.toString());
            return this;
        }

        public final List<ElasticGpuAssociation.Builder> getElasticGpuAssociations() {
            List<ElasticGpuAssociation.Builder> result = ElasticGpuAssociationListCopier.copyToBuilder(this.elasticGpuAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuAssociations(Collection<ElasticGpuAssociation.BuilderImpl> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copyFromBuilder(elasticGpuAssociations);
        }

        @Override
        public final Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copy(elasticGpuAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuAssociations(ElasticGpuAssociation ... elasticGpuAssociations) {
            this.elasticGpuAssociations(Arrays.asList(elasticGpuAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuAssociations(Consumer<ElasticGpuAssociation.Builder> ... elasticGpuAssociations) {
            this.elasticGpuAssociations(Stream.of(elasticGpuAssociations).map(c -> (ElasticGpuAssociation)((ElasticGpuAssociation.Builder)ElasticGpuAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ElasticInferenceAcceleratorAssociation.Builder> getElasticInferenceAcceleratorAssociations() {
            List<ElasticInferenceAcceleratorAssociation.Builder> result = ElasticInferenceAcceleratorAssociationListCopier.copyToBuilder(this.elasticInferenceAcceleratorAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticInferenceAcceleratorAssociations(Collection<ElasticInferenceAcceleratorAssociation.BuilderImpl> elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations = ElasticInferenceAcceleratorAssociationListCopier.copyFromBuilder(elasticInferenceAcceleratorAssociations);
        }

        @Override
        public final Builder elasticInferenceAcceleratorAssociations(Collection<ElasticInferenceAcceleratorAssociation> elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations = ElasticInferenceAcceleratorAssociationListCopier.copy(elasticInferenceAcceleratorAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorAssociations(ElasticInferenceAcceleratorAssociation ... elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations(Arrays.asList(elasticInferenceAcceleratorAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorAssociations(Consumer<ElasticInferenceAcceleratorAssociation.Builder> ... elasticInferenceAcceleratorAssociations) {
            this.elasticInferenceAcceleratorAssociations(Stream.of(elasticInferenceAcceleratorAssociations).map(c -> (ElasticInferenceAcceleratorAssociation)((ElasticInferenceAcceleratorAssociation.Builder)ElasticInferenceAcceleratorAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceNetworkInterface.Builder> getNetworkInterfaces() {
            List<InstanceNetworkInterface.Builder> result = InstanceNetworkInterfaceListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterface)((InstanceNetworkInterface.Builder)InstanceNetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType == null ? null : rootDeviceType.toString());
            return this;
        }

        public final List<GroupIdentifier.Builder> getSecurityGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<GroupIdentifier.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final StateReason.Builder getStateReason() {
            return this.stateReason != null ? this.stateReason.toBuilder() : null;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType == null ? null : virtualizationType.toString());
            return this;
        }

        public final CpuOptions.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final CapacityReservationSpecificationResponse.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(CapacityReservationSpecificationResponse.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecificationResponse capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final HibernationOptions.Builder getHibernationOptions() {
            return this.hibernationOptions != null ? this.hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(HibernationOptions.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(HibernationOptions hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final List<LicenseConfiguration.Builder> getLicenses() {
            List<LicenseConfiguration.Builder> result = LicenseListCopier.copyToBuilder(this.licenses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenses(Collection<LicenseConfiguration.BuilderImpl> licenses) {
            this.licenses = LicenseListCopier.copyFromBuilder(licenses);
        }

        @Override
        public final Builder licenses(Collection<LicenseConfiguration> licenses) {
            this.licenses = LicenseListCopier.copy(licenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(LicenseConfiguration ... licenses) {
            this.licenses(Arrays.asList(licenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(Consumer<LicenseConfiguration.Builder> ... licenses) {
            this.licenses(Stream.of(licenses).map(c -> (LicenseConfiguration)((LicenseConfiguration.Builder)LicenseConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceMetadataOptionsResponse.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(InstanceMetadataOptionsResponse.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptionsResponse metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final EnclaveOptions.Builder getEnclaveOptions() {
            return this.enclaveOptions != null ? this.enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(EnclaveOptions.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(EnclaveOptions enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final String getBootMode() {
            return this.bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final String getPlatformDetails() {
            return this.platformDetails;
        }

        public final void setPlatformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
        }

        @Override
        public final Builder platformDetails(String platformDetails) {
            this.platformDetails = platformDetails;
            return this;
        }

        public final String getUsageOperation() {
            return this.usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final Instant getUsageOperationUpdateTime() {
            return this.usageOperationUpdateTime;
        }

        public final void setUsageOperationUpdateTime(Instant usageOperationUpdateTime) {
            this.usageOperationUpdateTime = usageOperationUpdateTime;
        }

        @Override
        public final Builder usageOperationUpdateTime(Instant usageOperationUpdateTime) {
            this.usageOperationUpdateTime = usageOperationUpdateTime;
            return this;
        }

        public final PrivateDnsNameOptionsResponse.Builder getPrivateDnsNameOptions() {
            return this.privateDnsNameOptions != null ? this.privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(PrivateDnsNameOptionsResponse.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(PrivateDnsNameOptionsResponse privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final String getIpv6Address() {
            return this.ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final String getTpmSupport() {
            return this.tpmSupport;
        }

        public final void setTpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
        }

        @Override
        public final Builder tpmSupport(String tpmSupport) {
            this.tpmSupport = tpmSupport;
            return this;
        }

        public final InstanceMaintenanceOptions.Builder getMaintenanceOptions() {
            return this.maintenanceOptions != null ? this.maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(InstanceMaintenanceOptions.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(InstanceMaintenanceOptions maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder amiLaunchIndex(Integer var1);

        public Builder imageId(String var1);

        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder launchTime(Instant var1);

        public Builder monitoring(Monitoring var1);

        default public Builder monitoring(Consumer<Monitoring.Builder> monitoring) {
            return this.monitoring((Monitoring)((Monitoring.Builder)Monitoring.builder().applyMutation(monitoring)).build());
        }

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().applyMutation(placement)).build());
        }

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder publicDnsName(String var1);

        public Builder publicIpAddress(String var1);

        public Builder ramdiskId(String var1);

        public Builder state(InstanceState var1);

        default public Builder state(Consumer<InstanceState.Builder> state) {
            return this.state((InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation(state)).build());
        }

        public Builder stateTransitionReason(String var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder enaSupport(Boolean var1);

        public Builder hypervisor(String var1);

        public Builder hypervisor(HypervisorType var1);

        public Builder iamInstanceProfile(IamInstanceProfile var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfile)((IamInstanceProfile.Builder)IamInstanceProfile.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder instanceLifecycle(String var1);

        public Builder instanceLifecycle(InstanceLifecycleType var1);

        public Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> var1);

        public Builder elasticGpuAssociations(ElasticGpuAssociation ... var1);

        public Builder elasticGpuAssociations(Consumer<ElasticGpuAssociation.Builder> ... var1);

        public Builder elasticInferenceAcceleratorAssociations(Collection<ElasticInferenceAcceleratorAssociation> var1);

        public Builder elasticInferenceAcceleratorAssociations(ElasticInferenceAcceleratorAssociation ... var1);

        public Builder elasticInferenceAcceleratorAssociations(Consumer<ElasticInferenceAcceleratorAssociation.Builder> ... var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterface> var1);

        public Builder networkInterfaces(InstanceNetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterface.Builder> ... var1);

        public Builder outpostArn(String var1);

        public Builder rootDeviceName(String var1);

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(DeviceType var1);

        public Builder securityGroups(Collection<GroupIdentifier> var1);

        public Builder securityGroups(GroupIdentifier ... var1);

        public Builder securityGroups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder spotInstanceRequestId(String var1);

        public Builder sriovNetSupport(String var1);

        public Builder stateReason(StateReason var1);

        default public Builder stateReason(Consumer<StateReason.Builder> stateReason) {
            return this.stateReason((StateReason)((StateReason.Builder)StateReason.builder().applyMutation(stateReason)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder virtualizationType(String var1);

        public Builder virtualizationType(VirtualizationType var1);

        public Builder cpuOptions(CpuOptions var1);

        default public Builder cpuOptions(Consumer<CpuOptions.Builder> cpuOptions) {
            return this.cpuOptions((CpuOptions)((CpuOptions.Builder)CpuOptions.builder().applyMutation(cpuOptions)).build());
        }

        public Builder capacityReservationId(String var1);

        public Builder capacityReservationSpecification(CapacityReservationSpecificationResponse var1);

        default public Builder capacityReservationSpecification(Consumer<CapacityReservationSpecificationResponse.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((CapacityReservationSpecificationResponse)((CapacityReservationSpecificationResponse.Builder)CapacityReservationSpecificationResponse.builder().applyMutation(capacityReservationSpecification)).build());
        }

        public Builder hibernationOptions(HibernationOptions var1);

        default public Builder hibernationOptions(Consumer<HibernationOptions.Builder> hibernationOptions) {
            return this.hibernationOptions((HibernationOptions)((HibernationOptions.Builder)HibernationOptions.builder().applyMutation(hibernationOptions)).build());
        }

        public Builder licenses(Collection<LicenseConfiguration> var1);

        public Builder licenses(LicenseConfiguration ... var1);

        public Builder licenses(Consumer<LicenseConfiguration.Builder> ... var1);

        public Builder metadataOptions(InstanceMetadataOptionsResponse var1);

        default public Builder metadataOptions(Consumer<InstanceMetadataOptionsResponse.Builder> metadataOptions) {
            return this.metadataOptions((InstanceMetadataOptionsResponse)((InstanceMetadataOptionsResponse.Builder)InstanceMetadataOptionsResponse.builder().applyMutation(metadataOptions)).build());
        }

        public Builder enclaveOptions(EnclaveOptions var1);

        default public Builder enclaveOptions(Consumer<EnclaveOptions.Builder> enclaveOptions) {
            return this.enclaveOptions((EnclaveOptions)((EnclaveOptions.Builder)EnclaveOptions.builder().applyMutation(enclaveOptions)).build());
        }

        public Builder bootMode(String var1);

        public Builder bootMode(BootModeValues var1);

        public Builder platformDetails(String var1);

        public Builder usageOperation(String var1);

        public Builder usageOperationUpdateTime(Instant var1);

        public Builder privateDnsNameOptions(PrivateDnsNameOptionsResponse var1);

        default public Builder privateDnsNameOptions(Consumer<PrivateDnsNameOptionsResponse.Builder> privateDnsNameOptions) {
            return this.privateDnsNameOptions((PrivateDnsNameOptionsResponse)((PrivateDnsNameOptionsResponse.Builder)PrivateDnsNameOptionsResponse.builder().applyMutation(privateDnsNameOptions)).build());
        }

        public Builder ipv6Address(String var1);

        public Builder tpmSupport(String var1);

        public Builder maintenanceOptions(InstanceMaintenanceOptions var1);

        default public Builder maintenanceOptions(Consumer<InstanceMaintenanceOptions.Builder> maintenanceOptions) {
            return this.maintenanceOptions((InstanceMaintenanceOptions)((InstanceMaintenanceOptions.Builder)InstanceMaintenanceOptions.builder().applyMutation(maintenanceOptions)).build());
        }
    }
}

