/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTypeOffering;

public class DescribeInstanceTypeOfferingsIterable
implements SdkIterable<DescribeInstanceTypeOfferingsResponse> {
    private final Ec2Client client;
    private final DescribeInstanceTypeOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceTypeOfferingsIterable(Ec2Client client, DescribeInstanceTypeOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceTypeOfferingsResponseFetcher();
    }

    public Iterator<DescribeInstanceTypeOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceTypeOffering> instanceTypeOfferings() {
        Function<DescribeInstanceTypeOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypeOfferings() != null) {
                return response.instanceTypeOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceTypeOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeInstanceTypeOfferingsResponse> {
        private DescribeInstanceTypeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceTypeOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceTypeOfferingsResponse nextPage(DescribeInstanceTypeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceTypeOfferingsIterable.this.client.describeInstanceTypeOfferings(DescribeInstanceTypeOfferingsIterable.this.firstRequest);
            }
            return DescribeInstanceTypeOfferingsIterable.this.client.describeInstanceTypeOfferings((DescribeInstanceTypeOfferingsRequest)((Object)DescribeInstanceTypeOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

