/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GpuDeviceInfo;
import software.amazon.awssdk.services.ec2.model.GpuDeviceInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GpuInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GpuInfo> {
    private static final SdkField<List<GpuDeviceInfo>> GPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Gpus").getter(GpuInfo.getter(GpuInfo::gpus)).setter(GpuInfo.setter(Builder::gpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gpus").unmarshallLocationName("gpus").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GpuDeviceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_GPU_MEMORY_IN_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalGpuMemoryInMiB").getter(GpuInfo.getter(GpuInfo::totalGpuMemoryInMiB)).setter(GpuInfo.setter(Builder::totalGpuMemoryInMiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalGpuMemoryInMiB").unmarshallLocationName("totalGpuMemoryInMiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GPUS_FIELD, TOTAL_GPU_MEMORY_IN_MIB_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<GpuDeviceInfo> gpus;
    private final Integer totalGpuMemoryInMiB;

    private GpuInfo(BuilderImpl builder) {
        this.gpus = builder.gpus;
        this.totalGpuMemoryInMiB = builder.totalGpuMemoryInMiB;
    }

    public final boolean hasGpus() {
        return this.gpus != null && !(this.gpus instanceof SdkAutoConstructList);
    }

    public final List<GpuDeviceInfo> gpus() {
        return this.gpus;
    }

    public final Integer totalGpuMemoryInMiB() {
        return this.totalGpuMemoryInMiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGpus() ? this.gpus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalGpuMemoryInMiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuInfo)) {
            return false;
        }
        GpuInfo other = (GpuInfo)obj;
        return this.hasGpus() == other.hasGpus() && Objects.equals(this.gpus(), other.gpus()) && Objects.equals(this.totalGpuMemoryInMiB(), other.totalGpuMemoryInMiB());
    }

    public final String toString() {
        return ToString.builder((String)"GpuInfo").add("Gpus", this.hasGpus() ? this.gpus() : null).add("TotalGpuMemoryInMiB", (Object)this.totalGpuMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gpus": {
                return Optional.ofNullable(clazz.cast(this.gpus()));
            }
            case "TotalGpuMemoryInMiB": {
                return Optional.ofNullable(clazz.cast(this.totalGpuMemoryInMiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GpuInfo, T> g) {
        return obj -> g.apply((GpuInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GpuDeviceInfo> gpus = DefaultSdkAutoConstructList.getInstance();
        private Integer totalGpuMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(GpuInfo model) {
            this.gpus(model.gpus);
            this.totalGpuMemoryInMiB(model.totalGpuMemoryInMiB);
        }

        public final List<GpuDeviceInfo.Builder> getGpus() {
            List<GpuDeviceInfo.Builder> result = GpuDeviceInfoListCopier.copyToBuilder(this.gpus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGpus(Collection<GpuDeviceInfo.BuilderImpl> gpus) {
            this.gpus = GpuDeviceInfoListCopier.copyFromBuilder(gpus);
        }

        @Override
        @Transient
        public final Builder gpus(Collection<GpuDeviceInfo> gpus) {
            this.gpus = GpuDeviceInfoListCopier.copy(gpus);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gpus(GpuDeviceInfo ... gpus) {
            this.gpus(Arrays.asList(gpus));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gpus(Consumer<GpuDeviceInfo.Builder> ... gpus) {
            this.gpus(Stream.of(gpus).map(c -> (GpuDeviceInfo)((GpuDeviceInfo.Builder)GpuDeviceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalGpuMemoryInMiB() {
            return this.totalGpuMemoryInMiB;
        }

        public final void setTotalGpuMemoryInMiB(Integer totalGpuMemoryInMiB) {
            this.totalGpuMemoryInMiB = totalGpuMemoryInMiB;
        }

        @Override
        @Transient
        public final Builder totalGpuMemoryInMiB(Integer totalGpuMemoryInMiB) {
            this.totalGpuMemoryInMiB = totalGpuMemoryInMiB;
            return this;
        }

        public GpuInfo build() {
            return new GpuInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GpuInfo> {
        public Builder gpus(Collection<GpuDeviceInfo> var1);

        public Builder gpus(GpuDeviceInfo ... var1);

        public Builder gpus(Consumer<GpuDeviceInfo.Builder> ... var1);

        public Builder totalGpuMemoryInMiB(Integer var1);
    }
}

