/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IamInstanceProfileAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IamInstanceProfileAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(IamInstanceProfileAssociation.getter(IamInstanceProfileAssociation::associationId)).setter(IamInstanceProfileAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(IamInstanceProfileAssociation.getter(IamInstanceProfileAssociation::instanceId)).setter(IamInstanceProfileAssociation.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<IamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(IamInstanceProfileAssociation.getter(IamInstanceProfileAssociation::iamInstanceProfile)).setter(IamInstanceProfileAssociation.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("iamInstanceProfile").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IamInstanceProfileAssociation.getter(IamInstanceProfileAssociation::stateAsString)).setter(IamInstanceProfileAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(IamInstanceProfileAssociation.getter(IamInstanceProfileAssociation::timestamp)).setter(IamInstanceProfileAssociation.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").unmarshallLocationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, INSTANCE_ID_FIELD, IAM_INSTANCE_PROFILE_FIELD, STATE_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String instanceId;
    private final IamInstanceProfile iamInstanceProfile;
    private final String state;
    private final Instant timestamp;

    private IamInstanceProfileAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.instanceId = builder.instanceId;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.state = builder.state;
        this.timestamp = builder.timestamp;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final IamInstanceProfile iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final IamInstanceProfileAssociationState state() {
        return IamInstanceProfileAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamInstanceProfileAssociation)) {
            return false;
        }
        IamInstanceProfileAssociation other = (IamInstanceProfileAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"IamInstanceProfileAssociation").add("AssociationId", (Object)this.associationId()).add("InstanceId", (Object)this.instanceId()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("State", (Object)this.stateAsString()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IamInstanceProfileAssociation, T> g) {
        return obj -> g.apply((IamInstanceProfileAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String instanceId;
        private IamInstanceProfile iamInstanceProfile;
        private String state;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(IamInstanceProfileAssociation model) {
            this.associationId(model.associationId);
            this.instanceId(model.instanceId);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.state(model.state);
            this.timestamp(model.timestamp);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        @Transient
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(IamInstanceProfileAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public IamInstanceProfileAssociation build() {
            return new IamInstanceProfileAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IamInstanceProfileAssociation> {
        public Builder associationId(String var1);

        public Builder instanceId(String var1);

        public Builder iamInstanceProfile(IamInstanceProfile var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfile)((IamInstanceProfile.Builder)IamInstanceProfile.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder state(String var1);

        public Builder state(IamInstanceProfileAssociationState var1);

        public Builder timestamp(Instant var1);
    }
}

