/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceCreditSpecificationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceCreditSpecificationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceCreditSpecificationRequest.getter(InstanceCreditSpecificationRequest::instanceId)).setter(InstanceCreditSpecificationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<String> CPU_CREDITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CpuCredits").getter(InstanceCreditSpecificationRequest.getter(InstanceCreditSpecificationRequest::cpuCredits)).setter(InstanceCreditSpecificationRequest.setter(Builder::cpuCredits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuCredits").unmarshallLocationName("CpuCredits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CPU_CREDITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String cpuCredits;

    private InstanceCreditSpecificationRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.cpuCredits = builder.cpuCredits;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String cpuCredits() {
        return this.cpuCredits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCredits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCreditSpecificationRequest)) {
            return false;
        }
        InstanceCreditSpecificationRequest other = (InstanceCreditSpecificationRequest)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.cpuCredits(), other.cpuCredits());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceCreditSpecificationRequest").add("InstanceId", (Object)this.instanceId()).add("CpuCredits", (Object)this.cpuCredits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "CpuCredits": {
                return Optional.ofNullable(clazz.cast(this.cpuCredits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceCreditSpecificationRequest, T> g) {
        return obj -> g.apply((InstanceCreditSpecificationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String cpuCredits;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCreditSpecificationRequest model) {
            this.instanceId(model.instanceId);
            this.cpuCredits(model.cpuCredits);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getCpuCredits() {
            return this.cpuCredits;
        }

        public final void setCpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
        }

        @Override
        @Transient
        public final Builder cpuCredits(String cpuCredits) {
            this.cpuCredits = cpuCredits;
            return this;
        }

        public InstanceCreditSpecificationRequest build() {
            return new InstanceCreditSpecificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceCreditSpecificationRequest> {
        public Builder instanceId(String var1);

        public Builder cpuCredits(String var1);
    }
}

