/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SubnetCidrReservationType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetCidrReservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubnetCidrReservation> {
    private static final SdkField<String> SUBNET_CIDR_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetCidrReservationId").getter(SubnetCidrReservation.getter(SubnetCidrReservation::subnetCidrReservationId)).setter(SubnetCidrReservation.setter(Builder::subnetCidrReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetCidrReservationId").unmarshallLocationName("subnetCidrReservationId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(SubnetCidrReservation.getter(SubnetCidrReservation::subnetId)).setter(SubnetCidrReservation.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(SubnetCidrReservation.getter(SubnetCidrReservation::cidr)).setter(SubnetCidrReservation.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("cidr").build()}).build();
    private static final SdkField<String> RESERVATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationType").getter(SubnetCidrReservation.getter(SubnetCidrReservation::reservationTypeAsString)).setter(SubnetCidrReservation.setter(Builder::reservationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationType").unmarshallLocationName("reservationType").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SubnetCidrReservation.getter(SubnetCidrReservation::ownerId)).setter(SubnetCidrReservation.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SubnetCidrReservation.getter(SubnetCidrReservation::description)).setter(SubnetCidrReservation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SubnetCidrReservation.getter(SubnetCidrReservation::tags)).setter(SubnetCidrReservation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_CIDR_RESERVATION_ID_FIELD, SUBNET_ID_FIELD, CIDR_FIELD, RESERVATION_TYPE_FIELD, OWNER_ID_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subnetCidrReservationId;
    private final String subnetId;
    private final String cidr;
    private final String reservationType;
    private final String ownerId;
    private final String description;
    private final List<Tag> tags;

    private SubnetCidrReservation(BuilderImpl builder) {
        this.subnetCidrReservationId = builder.subnetCidrReservationId;
        this.subnetId = builder.subnetId;
        this.cidr = builder.cidr;
        this.reservationType = builder.reservationType;
        this.ownerId = builder.ownerId;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String subnetCidrReservationId() {
        return this.subnetCidrReservationId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final SubnetCidrReservationType reservationType() {
        return SubnetCidrReservationType.fromValue(this.reservationType);
    }

    public final String reservationTypeAsString() {
        return this.reservationType;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetCidrReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetCidrReservation)) {
            return false;
        }
        SubnetCidrReservation other = (SubnetCidrReservation)obj;
        return Objects.equals(this.subnetCidrReservationId(), other.subnetCidrReservationId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.reservationTypeAsString(), other.reservationTypeAsString()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SubnetCidrReservation").add("SubnetCidrReservationId", (Object)this.subnetCidrReservationId()).add("SubnetId", (Object)this.subnetId()).add("Cidr", (Object)this.cidr()).add("ReservationType", (Object)this.reservationTypeAsString()).add("OwnerId", (Object)this.ownerId()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetCidrReservationId": {
                return Optional.ofNullable(clazz.cast(this.subnetCidrReservationId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "ReservationType": {
                return Optional.ofNullable(clazz.cast(this.reservationTypeAsString()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetCidrReservation, T> g) {
        return obj -> g.apply((SubnetCidrReservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetCidrReservationId;
        private String subnetId;
        private String cidr;
        private String reservationType;
        private String ownerId;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetCidrReservation model) {
            this.subnetCidrReservationId(model.subnetCidrReservationId);
            this.subnetId(model.subnetId);
            this.cidr(model.cidr);
            this.reservationType(model.reservationType);
            this.ownerId(model.ownerId);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getSubnetCidrReservationId() {
            return this.subnetCidrReservationId;
        }

        public final void setSubnetCidrReservationId(String subnetCidrReservationId) {
            this.subnetCidrReservationId = subnetCidrReservationId;
        }

        @Override
        @Transient
        public final Builder subnetCidrReservationId(String subnetCidrReservationId) {
            this.subnetCidrReservationId = subnetCidrReservationId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        @Transient
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getReservationType() {
            return this.reservationType;
        }

        public final void setReservationType(String reservationType) {
            this.reservationType = reservationType;
        }

        @Override
        @Transient
        public final Builder reservationType(String reservationType) {
            this.reservationType = reservationType;
            return this;
        }

        @Override
        @Transient
        public final Builder reservationType(SubnetCidrReservationType reservationType) {
            this.reservationType(reservationType == null ? null : reservationType.toString());
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SubnetCidrReservation build() {
            return new SubnetCidrReservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubnetCidrReservation> {
        public Builder subnetCidrReservationId(String var1);

        public Builder subnetId(String var1);

        public Builder cidr(String var1);

        public Builder reservationType(String var1);

        public Builder reservationType(SubnetCidrReservationType var1);

        public Builder ownerId(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

