/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowDisassociationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateInstanceEventWindowRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DisassociateInstanceEventWindowRequest> {
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceEventWindowId").getter(DisassociateInstanceEventWindowRequest.getter(DisassociateInstanceEventWindowRequest::instanceEventWindowId)).setter(DisassociateInstanceEventWindowRequest.setter(Builder::instanceEventWindowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId").unmarshallLocationName("InstanceEventWindowId").build()}).build();
    private static final SdkField<InstanceEventWindowDisassociationRequest> ASSOCIATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationTarget").getter(DisassociateInstanceEventWindowRequest.getter(DisassociateInstanceEventWindowRequest::associationTarget)).setter(DisassociateInstanceEventWindowRequest.setter(Builder::associationTarget)).constructor(InstanceEventWindowDisassociationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTarget").unmarshallLocationName("AssociationTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_WINDOW_ID_FIELD, ASSOCIATION_TARGET_FIELD));
    private final String instanceEventWindowId;
    private final InstanceEventWindowDisassociationRequest associationTarget;

    private DisassociateInstanceEventWindowRequest(BuilderImpl builder) {
        super(builder);
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.associationTarget = builder.associationTarget;
    }

    public final String instanceEventWindowId() {
        return this.instanceEventWindowId;
    }

    public final InstanceEventWindowDisassociationRequest associationTarget() {
        return this.associationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateInstanceEventWindowRequest)) {
            return false;
        }
        DisassociateInstanceEventWindowRequest other = (DisassociateInstanceEventWindowRequest)((Object)obj);
        return Objects.equals(this.instanceEventWindowId(), other.instanceEventWindowId()) && Objects.equals(this.associationTarget(), other.associationTarget());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateInstanceEventWindowRequest").add("InstanceEventWindowId", (Object)this.instanceEventWindowId()).add("AssociationTarget", (Object)this.associationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceEventWindowId": {
                return Optional.ofNullable(clazz.cast(this.instanceEventWindowId()));
            }
            case "AssociationTarget": {
                return Optional.ofNullable(clazz.cast(this.associationTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateInstanceEventWindowRequest, T> g) {
        return obj -> g.apply((DisassociateInstanceEventWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceEventWindowId;
        private InstanceEventWindowDisassociationRequest associationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateInstanceEventWindowRequest model) {
            super(model);
            this.instanceEventWindowId(model.instanceEventWindowId);
            this.associationTarget(model.associationTarget);
        }

        public final String getInstanceEventWindowId() {
            return this.instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        @Transient
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final InstanceEventWindowDisassociationRequest.Builder getAssociationTarget() {
            return this.associationTarget != null ? this.associationTarget.toBuilder() : null;
        }

        public final void setAssociationTarget(InstanceEventWindowDisassociationRequest.BuilderImpl associationTarget) {
            this.associationTarget = associationTarget != null ? associationTarget.build() : null;
        }

        @Override
        @Transient
        public final Builder associationTarget(InstanceEventWindowDisassociationRequest associationTarget) {
            this.associationTarget = associationTarget;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateInstanceEventWindowRequest build() {
            return new DisassociateInstanceEventWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateInstanceEventWindowRequest> {
        public Builder instanceEventWindowId(String var1);

        public Builder associationTarget(InstanceEventWindowDisassociationRequest var1);

        default public Builder associationTarget(Consumer<InstanceEventWindowDisassociationRequest.Builder> associationTarget) {
            return this.associationTarget((InstanceEventWindowDisassociationRequest)((InstanceEventWindowDisassociationRequest.Builder)InstanceEventWindowDisassociationRequest.builder().applyMutation(associationTarget)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

