/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamScopeState;
import software.amazon.awssdk.services.ec2.model.IpamScopeType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamScope> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(IpamScope.getter(IpamScope::ownerId)).setter(IpamScope.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeId").getter(IpamScope.getter(IpamScope::ipamScopeId)).setter(IpamScope.setter(Builder::ipamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeId").unmarshallLocationName("ipamScopeId").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeArn").getter(IpamScope.getter(IpamScope::ipamScopeArn)).setter(IpamScope.setter(Builder::ipamScopeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeArn").unmarshallLocationName("ipamScopeArn").build()}).build();
    private static final SdkField<String> IPAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamArn").getter(IpamScope.getter(IpamScope::ipamArn)).setter(IpamScope.setter(Builder::ipamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamArn").unmarshallLocationName("ipamArn").build()}).build();
    private static final SdkField<String> IPAM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamRegion").getter(IpamScope.getter(IpamScope::ipamRegion)).setter(IpamScope.setter(Builder::ipamRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamRegion").unmarshallLocationName("ipamRegion").build()}).build();
    private static final SdkField<String> IPAM_SCOPE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeType").getter(IpamScope.getter(IpamScope::ipamScopeTypeAsString)).setter(IpamScope.setter(Builder::ipamScopeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeType").unmarshallLocationName("ipamScopeType").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(IpamScope.getter(IpamScope::isDefault)).setter(IpamScope.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").unmarshallLocationName("isDefault").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(IpamScope.getter(IpamScope::description)).setter(IpamScope.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Integer> POOL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PoolCount").getter(IpamScope.getter(IpamScope::poolCount)).setter(IpamScope.setter(Builder::poolCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolCount").unmarshallLocationName("poolCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamScope.getter(IpamScope::stateAsString)).setter(IpamScope.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamScope.getter(IpamScope::tags)).setter(IpamScope.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, IPAM_SCOPE_ID_FIELD, IPAM_SCOPE_ARN_FIELD, IPAM_ARN_FIELD, IPAM_REGION_FIELD, IPAM_SCOPE_TYPE_FIELD, IS_DEFAULT_FIELD, DESCRIPTION_FIELD, POOL_COUNT_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ipamScopeId;
    private final String ipamScopeArn;
    private final String ipamArn;
    private final String ipamRegion;
    private final String ipamScopeType;
    private final Boolean isDefault;
    private final String description;
    private final Integer poolCount;
    private final String state;
    private final List<Tag> tags;

    private IpamScope(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ipamScopeId = builder.ipamScopeId;
        this.ipamScopeArn = builder.ipamScopeArn;
        this.ipamArn = builder.ipamArn;
        this.ipamRegion = builder.ipamRegion;
        this.ipamScopeType = builder.ipamScopeType;
        this.isDefault = builder.isDefault;
        this.description = builder.description;
        this.poolCount = builder.poolCount;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ipamScopeId() {
        return this.ipamScopeId;
    }

    public final String ipamScopeArn() {
        return this.ipamScopeArn;
    }

    public final String ipamArn() {
        return this.ipamArn;
    }

    public final String ipamRegion() {
        return this.ipamRegion;
    }

    public final IpamScopeType ipamScopeType() {
        return IpamScopeType.fromValue(this.ipamScopeType);
    }

    public final String ipamScopeTypeAsString() {
        return this.ipamScopeType;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final String description() {
        return this.description;
    }

    public final Integer poolCount() {
        return this.poolCount;
    }

    public final IpamScopeState state() {
        return IpamScopeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamScope)) {
            return false;
        }
        IpamScope other = (IpamScope)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ipamScopeId(), other.ipamScopeId()) && Objects.equals(this.ipamScopeArn(), other.ipamScopeArn()) && Objects.equals(this.ipamArn(), other.ipamArn()) && Objects.equals(this.ipamRegion(), other.ipamRegion()) && Objects.equals(this.ipamScopeTypeAsString(), other.ipamScopeTypeAsString()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.poolCount(), other.poolCount()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"IpamScope").add("OwnerId", (Object)this.ownerId()).add("IpamScopeId", (Object)this.ipamScopeId()).add("IpamScopeArn", (Object)this.ipamScopeArn()).add("IpamArn", (Object)this.ipamArn()).add("IpamRegion", (Object)this.ipamRegion()).add("IpamScopeType", (Object)this.ipamScopeTypeAsString()).add("IsDefault", (Object)this.isDefault()).add("Description", (Object)this.description()).add("PoolCount", (Object)this.poolCount()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "IpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeId()));
            }
            case "IpamScopeArn": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeArn()));
            }
            case "IpamArn": {
                return Optional.ofNullable(clazz.cast(this.ipamArn()));
            }
            case "IpamRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamRegion()));
            }
            case "IpamScopeType": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeTypeAsString()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PoolCount": {
                return Optional.ofNullable(clazz.cast(this.poolCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamScope, T> g) {
        return obj -> g.apply((IpamScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ipamScopeId;
        private String ipamScopeArn;
        private String ipamArn;
        private String ipamRegion;
        private String ipamScopeType;
        private Boolean isDefault;
        private String description;
        private Integer poolCount;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamScope model) {
            this.ownerId(model.ownerId);
            this.ipamScopeId(model.ipamScopeId);
            this.ipamScopeArn(model.ipamScopeArn);
            this.ipamArn(model.ipamArn);
            this.ipamRegion(model.ipamRegion);
            this.ipamScopeType(model.ipamScopeType);
            this.isDefault(model.isDefault);
            this.description(model.description);
            this.poolCount(model.poolCount);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getIpamScopeId() {
            return this.ipamScopeId;
        }

        public final void setIpamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
        }

        @Override
        @Transient
        public final Builder ipamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        public final String getIpamScopeArn() {
            return this.ipamScopeArn;
        }

        public final void setIpamScopeArn(String ipamScopeArn) {
            this.ipamScopeArn = ipamScopeArn;
        }

        @Override
        @Transient
        public final Builder ipamScopeArn(String ipamScopeArn) {
            this.ipamScopeArn = ipamScopeArn;
            return this;
        }

        public final String getIpamArn() {
            return this.ipamArn;
        }

        public final void setIpamArn(String ipamArn) {
            this.ipamArn = ipamArn;
        }

        @Override
        @Transient
        public final Builder ipamArn(String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        public final String getIpamRegion() {
            return this.ipamRegion;
        }

        public final void setIpamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
        }

        @Override
        @Transient
        public final Builder ipamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
            return this;
        }

        public final String getIpamScopeType() {
            return this.ipamScopeType;
        }

        public final void setIpamScopeType(String ipamScopeType) {
            this.ipamScopeType = ipamScopeType;
        }

        @Override
        @Transient
        public final Builder ipamScopeType(String ipamScopeType) {
            this.ipamScopeType = ipamScopeType;
            return this;
        }

        @Override
        @Transient
        public final Builder ipamScopeType(IpamScopeType ipamScopeType) {
            this.ipamScopeType(ipamScopeType == null ? null : ipamScopeType.toString());
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        @Transient
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getPoolCount() {
            return this.poolCount;
        }

        public final void setPoolCount(Integer poolCount) {
            this.poolCount = poolCount;
        }

        @Override
        @Transient
        public final Builder poolCount(Integer poolCount) {
            this.poolCount = poolCount;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(IpamScopeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamScope build() {
            return new IpamScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamScope> {
        public Builder ownerId(String var1);

        public Builder ipamScopeId(String var1);

        public Builder ipamScopeArn(String var1);

        public Builder ipamArn(String var1);

        public Builder ipamRegion(String var1);

        public Builder ipamScopeType(String var1);

        public Builder ipamScopeType(IpamScopeType var1);

        public Builder isDefault(Boolean var1);

        public Builder description(String var1);

        public Builder poolCount(Integer var1);

        public Builder state(String var1);

        public Builder state(IpamScopeState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

