/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupport;
import software.amazon.awssdk.services.ec2.model.ClassicLinkDnsSupportListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcClassicLinkDnsSupportResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcClassicLinkDnsSupportResponse.getter(DescribeVpcClassicLinkDnsSupportResponse::nextToken)).setter(DescribeVpcClassicLinkDnsSupportResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<ClassicLinkDnsSupport>> VPCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Vpcs").getter(DescribeVpcClassicLinkDnsSupportResponse.getter(DescribeVpcClassicLinkDnsSupportResponse::vpcs)).setter(DescribeVpcClassicLinkDnsSupportResponse.setter(Builder::vpcs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpcs").unmarshallLocationName("vpcs").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClassicLinkDnsSupport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VPCS_FIELD));
    private final String nextToken;
    private final List<ClassicLinkDnsSupport> vpcs;

    private DescribeVpcClassicLinkDnsSupportResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vpcs = builder.vpcs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVpcs() {
        return this.vpcs != null && !(this.vpcs instanceof SdkAutoConstructList);
    }

    public final List<ClassicLinkDnsSupport> vpcs() {
        return this.vpcs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcs() ? this.vpcs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkDnsSupportResponse)) {
            return false;
        }
        DescribeVpcClassicLinkDnsSupportResponse other = (DescribeVpcClassicLinkDnsSupportResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVpcs() == other.hasVpcs() && Objects.equals(this.vpcs(), other.vpcs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcClassicLinkDnsSupportResponse").add("NextToken", (Object)this.nextToken()).add("Vpcs", this.hasVpcs() ? this.vpcs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Vpcs": {
                return Optional.ofNullable(clazz.cast(this.vpcs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcClassicLinkDnsSupportResponse, T> g) {
        return obj -> g.apply((DescribeVpcClassicLinkDnsSupportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ClassicLinkDnsSupport> vpcs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkDnsSupportResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.vpcs(model.vpcs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ClassicLinkDnsSupport.Builder> getVpcs() {
            List<ClassicLinkDnsSupport.Builder> result = ClassicLinkDnsSupportListCopier.copyToBuilder(this.vpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcs(Collection<ClassicLinkDnsSupport.BuilderImpl> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copyFromBuilder(vpcs);
        }

        @Override
        @Transient
        public final Builder vpcs(Collection<ClassicLinkDnsSupport> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copy(vpcs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(ClassicLinkDnsSupport ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcs(Consumer<ClassicLinkDnsSupport.Builder> ... vpcs) {
            this.vpcs(Stream.of(vpcs).map(c -> (ClassicLinkDnsSupport)((ClassicLinkDnsSupport.Builder)ClassicLinkDnsSupport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpcClassicLinkDnsSupportResponse build() {
            return new DescribeVpcClassicLinkDnsSupportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportResponse> {
        public Builder nextToken(String var1);

        public Builder vpcs(Collection<ClassicLinkDnsSupport> var1);

        public Builder vpcs(ClassicLinkDnsSupport ... var1);

        public Builder vpcs(Consumer<ClassicLinkDnsSupport.Builder> ... var1);
    }
}

