/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TargetStorageTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySnapshotTierRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifySnapshotTierRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(ModifySnapshotTierRequest.getter(ModifySnapshotTierRequest::snapshotId)).setter(ModifySnapshotTierRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build();
    private static final SdkField<String> STORAGE_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageTier").getter(ModifySnapshotTierRequest.getter(ModifySnapshotTierRequest::storageTierAsString)).setter(ModifySnapshotTierRequest.setter(Builder::storageTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTier").unmarshallLocationName("StorageTier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, STORAGE_TIER_FIELD));
    private final String snapshotId;
    private final String storageTier;

    private ModifySnapshotTierRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.storageTier = builder.storageTier;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final TargetStorageTier storageTier() {
        return TargetStorageTier.fromValue(this.storageTier);
    }

    public final String storageTierAsString() {
        return this.storageTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotTierRequest)) {
            return false;
        }
        ModifySnapshotTierRequest other = (ModifySnapshotTierRequest)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.storageTierAsString(), other.storageTierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifySnapshotTierRequest").add("SnapshotId", (Object)this.snapshotId()).add("StorageTier", (Object)this.storageTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "StorageTier": {
                return Optional.ofNullable(clazz.cast(this.storageTierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotTierRequest, T> g) {
        return obj -> g.apply((ModifySnapshotTierRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String snapshotId;
        private String storageTier;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotTierRequest model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.storageTier(model.storageTier);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStorageTier() {
            return this.storageTier;
        }

        public final void setStorageTier(String storageTier) {
            this.storageTier = storageTier;
        }

        @Override
        @Transient
        public final Builder storageTier(String storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        @Override
        @Transient
        public final Builder storageTier(TargetStorageTier storageTier) {
            this.storageTier(storageTier == null ? null : storageTier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotTierRequest build() {
            return new ModifySnapshotTierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySnapshotTierRequest> {
        public Builder snapshotId(String var1);

        public Builder storageTier(String var1);

        public Builder storageTier(TargetStorageTier var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

