/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    CAPACITY_RESERVATION("capacity-reservation"),
    CLIENT_VPN_ENDPOINT("client-vpn-endpoint"),
    CUSTOMER_GATEWAY("customer-gateway"),
    CARRIER_GATEWAY("carrier-gateway"),
    DEDICATED_HOST("dedicated-host"),
    DHCP_OPTIONS("dhcp-options"),
    EGRESS_ONLY_INTERNET_GATEWAY("egress-only-internet-gateway"),
    ELASTIC_IP("elastic-ip"),
    ELASTIC_GPU("elastic-gpu"),
    EXPORT_IMAGE_TASK("export-image-task"),
    EXPORT_INSTANCE_TASK("export-instance-task"),
    FLEET("fleet"),
    FPGA_IMAGE("fpga-image"),
    HOST_RESERVATION("host-reservation"),
    IMAGE("image"),
    IMPORT_IMAGE_TASK("import-image-task"),
    IMPORT_SNAPSHOT_TASK("import-snapshot-task"),
    INSTANCE("instance"),
    INSTANCE_EVENT_WINDOW("instance-event-window"),
    INTERNET_GATEWAY("internet-gateway"),
    IPAM("ipam"),
    IPAM_POOL("ipam-pool"),
    IPAM_SCOPE("ipam-scope"),
    IPV4_POOL_EC2("ipv4pool-ec2"),
    IPV6_POOL_EC2("ipv6pool-ec2"),
    KEY_PAIR("key-pair"),
    LAUNCH_TEMPLATE("launch-template"),
    LOCAL_GATEWAY("local-gateway"),
    LOCAL_GATEWAY_ROUTE_TABLE("local-gateway-route-table"),
    LOCAL_GATEWAY_VIRTUAL_INTERFACE("local-gateway-virtual-interface"),
    LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP("local-gateway-virtual-interface-group"),
    LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION("local-gateway-route-table-vpc-association"),
    LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION("local-gateway-route-table-virtual-interface-group-association"),
    NATGATEWAY("natgateway"),
    NETWORK_ACL("network-acl"),
    NETWORK_INTERFACE("network-interface"),
    NETWORK_INSIGHTS_ANALYSIS("network-insights-analysis"),
    NETWORK_INSIGHTS_PATH("network-insights-path"),
    NETWORK_INSIGHTS_ACCESS_SCOPE("network-insights-access-scope"),
    NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS("network-insights-access-scope-analysis"),
    PLACEMENT_GROUP("placement-group"),
    PREFIX_LIST("prefix-list"),
    REPLACE_ROOT_VOLUME_TASK("replace-root-volume-task"),
    RESERVED_INSTANCES("reserved-instances"),
    ROUTE_TABLE("route-table"),
    SECURITY_GROUP("security-group"),
    SECURITY_GROUP_RULE("security-group-rule"),
    SNAPSHOT("snapshot"),
    SPOT_FLEET_REQUEST("spot-fleet-request"),
    SPOT_INSTANCES_REQUEST("spot-instances-request"),
    SUBNET("subnet"),
    TRAFFIC_MIRROR_FILTER("traffic-mirror-filter"),
    TRAFFIC_MIRROR_SESSION("traffic-mirror-session"),
    TRAFFIC_MIRROR_TARGET("traffic-mirror-target"),
    TRANSIT_GATEWAY("transit-gateway"),
    TRANSIT_GATEWAY_ATTACHMENT("transit-gateway-attachment"),
    TRANSIT_GATEWAY_CONNECT_PEER("transit-gateway-connect-peer"),
    TRANSIT_GATEWAY_MULTICAST_DOMAIN("transit-gateway-multicast-domain"),
    TRANSIT_GATEWAY_ROUTE_TABLE("transit-gateway-route-table"),
    VOLUME("volume"),
    VPC("vpc"),
    VPC_ENDPOINT("vpc-endpoint"),
    VPC_ENDPOINT_SERVICE("vpc-endpoint-service"),
    VPC_PEERING_CONNECTION("vpc-peering-connection"),
    VPN_CONNECTION("vpn-connection"),
    VPN_GATEWAY("vpn-gateway"),
    VPC_FLOW_LOG("vpc-flow-log"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

