/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocalGatewayRouteTablesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeLocalGatewayRouteTablesResponse> {
    private static final SdkField<List<LocalGatewayRouteTable>> LOCAL_GATEWAY_ROUTE_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalGatewayRouteTables").getter(DescribeLocalGatewayRouteTablesResponse.getter(DescribeLocalGatewayRouteTablesResponse::localGatewayRouteTables)).setter(DescribeLocalGatewayRouteTablesResponse.setter(Builder::localGatewayRouteTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableSet").unmarshallLocationName("localGatewayRouteTableSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalGatewayRouteTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLocalGatewayRouteTablesResponse.getter(DescribeLocalGatewayRouteTablesResponse::nextToken)).setter(DescribeLocalGatewayRouteTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_ROUTE_TABLES_FIELD, NEXT_TOKEN_FIELD));
    private final List<LocalGatewayRouteTable> localGatewayRouteTables;
    private final String nextToken;

    private DescribeLocalGatewayRouteTablesResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTables = builder.localGatewayRouteTables;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLocalGatewayRouteTables() {
        return this.localGatewayRouteTables != null && !(this.localGatewayRouteTables instanceof SdkAutoConstructList);
    }

    public final List<LocalGatewayRouteTable> localGatewayRouteTables() {
        return this.localGatewayRouteTables;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalGatewayRouteTables() ? this.localGatewayRouteTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewayRouteTablesResponse)) {
            return false;
        }
        DescribeLocalGatewayRouteTablesResponse other = (DescribeLocalGatewayRouteTablesResponse)((Object)obj);
        return this.hasLocalGatewayRouteTables() == other.hasLocalGatewayRouteTables() && Objects.equals(this.localGatewayRouteTables(), other.localGatewayRouteTables()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocalGatewayRouteTablesResponse").add("LocalGatewayRouteTables", this.hasLocalGatewayRouteTables() ? this.localGatewayRouteTables() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayRouteTables": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTables()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocalGatewayRouteTablesResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewayRouteTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<LocalGatewayRouteTable> localGatewayRouteTables = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewayRouteTablesResponse model) {
            super(model);
            this.localGatewayRouteTables(model.localGatewayRouteTables);
            this.nextToken(model.nextToken);
        }

        public final List<LocalGatewayRouteTable.Builder> getLocalGatewayRouteTables() {
            List<LocalGatewayRouteTable.Builder> result = LocalGatewayRouteTableSetCopier.copyToBuilder(this.localGatewayRouteTables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder localGatewayRouteTables(Collection<LocalGatewayRouteTable> localGatewayRouteTables) {
            this.localGatewayRouteTables = LocalGatewayRouteTableSetCopier.copy(localGatewayRouteTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTables(LocalGatewayRouteTable ... localGatewayRouteTables) {
            this.localGatewayRouteTables(Arrays.asList(localGatewayRouteTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTables(Consumer<LocalGatewayRouteTable.Builder> ... localGatewayRouteTables) {
            this.localGatewayRouteTables(Stream.of(localGatewayRouteTables).map(c -> (LocalGatewayRouteTable)((LocalGatewayRouteTable.Builder)LocalGatewayRouteTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalGatewayRouteTables(Collection<LocalGatewayRouteTable.BuilderImpl> localGatewayRouteTables) {
            this.localGatewayRouteTables = LocalGatewayRouteTableSetCopier.copyFromBuilder(localGatewayRouteTables);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLocalGatewayRouteTablesResponse build() {
            return new DescribeLocalGatewayRouteTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocalGatewayRouteTablesResponse> {
        public Builder localGatewayRouteTables(Collection<LocalGatewayRouteTable> var1);

        public Builder localGatewayRouteTables(LocalGatewayRouteTable ... var1);

        public Builder localGatewayRouteTables(Consumer<LocalGatewayRouteTable.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

