/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FederatedAuthentication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FederatedAuthentication> {
    private static final SdkField<String> SAML_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SamlProviderArn").getter(FederatedAuthentication.getter(FederatedAuthentication::samlProviderArn)).setter(FederatedAuthentication.setter(Builder::samlProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamlProviderArn").unmarshallLocationName("samlProviderArn").build()}).build();
    private static final SdkField<String> SELF_SERVICE_SAML_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelfServiceSamlProviderArn").getter(FederatedAuthentication.getter(FederatedAuthentication::selfServiceSamlProviderArn)).setter(FederatedAuthentication.setter(Builder::selfServiceSamlProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServiceSamlProviderArn").unmarshallLocationName("selfServiceSamlProviderArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_PROVIDER_ARN_FIELD, SELF_SERVICE_SAML_PROVIDER_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String samlProviderArn;
    private final String selfServiceSamlProviderArn;

    private FederatedAuthentication(BuilderImpl builder) {
        this.samlProviderArn = builder.samlProviderArn;
        this.selfServiceSamlProviderArn = builder.selfServiceSamlProviderArn;
    }

    public final String samlProviderArn() {
        return this.samlProviderArn;
    }

    public final String selfServiceSamlProviderArn() {
        return this.selfServiceSamlProviderArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfServiceSamlProviderArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederatedAuthentication)) {
            return false;
        }
        FederatedAuthentication other = (FederatedAuthentication)obj;
        return Objects.equals(this.samlProviderArn(), other.samlProviderArn()) && Objects.equals(this.selfServiceSamlProviderArn(), other.selfServiceSamlProviderArn());
    }

    public final String toString() {
        return ToString.builder((String)"FederatedAuthentication").add("SamlProviderArn", (Object)this.samlProviderArn()).add("SelfServiceSamlProviderArn", (Object)this.selfServiceSamlProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamlProviderArn": {
                return Optional.ofNullable(clazz.cast(this.samlProviderArn()));
            }
            case "SelfServiceSamlProviderArn": {
                return Optional.ofNullable(clazz.cast(this.selfServiceSamlProviderArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FederatedAuthentication, T> g) {
        return obj -> g.apply((FederatedAuthentication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String samlProviderArn;
        private String selfServiceSamlProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FederatedAuthentication model) {
            this.samlProviderArn(model.samlProviderArn);
            this.selfServiceSamlProviderArn(model.selfServiceSamlProviderArn);
        }

        public final String getSamlProviderArn() {
            return this.samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final void setSamlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        public final String getSelfServiceSamlProviderArn() {
            return this.selfServiceSamlProviderArn;
        }

        @Override
        public final Builder selfServiceSamlProviderArn(String selfServiceSamlProviderArn) {
            this.selfServiceSamlProviderArn = selfServiceSamlProviderArn;
            return this;
        }

        public final void setSelfServiceSamlProviderArn(String selfServiceSamlProviderArn) {
            this.selfServiceSamlProviderArn = selfServiceSamlProviderArn;
        }

        public FederatedAuthentication build() {
            return new FederatedAuthentication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FederatedAuthentication> {
        public Builder samlProviderArn(String var1);

        public Builder selfServiceSamlProviderArn(String var1);
    }
}

