/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAssociation;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayRouteTableAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetTransitGatewayRouteTableAssociationsResponse> {
    private static final SdkField<List<TransitGatewayRouteTableAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(GetTransitGatewayRouteTableAssociationsResponse.getter(GetTransitGatewayRouteTableAssociationsResponse::associations)).setter(GetTransitGatewayRouteTableAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").unmarshallLocationName("associations").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRouteTableAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayRouteTableAssociationsResponse.getter(GetTransitGatewayRouteTableAssociationsResponse::nextToken)).setter(GetTransitGatewayRouteTableAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayRouteTableAssociation> associations;
    private final String nextToken;

    private GetTransitGatewayRouteTableAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayRouteTableAssociation> associations() {
        return this.associations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayRouteTableAssociationsResponse)) {
            return false;
        }
        GetTransitGatewayRouteTableAssociationsResponse other = (GetTransitGatewayRouteTableAssociationsResponse)((Object)obj);
        return this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransitGatewayRouteTableAssociationsResponse").add("Associations", this.hasAssociations() ? this.associations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayRouteTableAssociationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayRouteTableAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayRouteTableAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayRouteTableAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayRouteTableAssociation.Builder> getAssociations() {
            List<TransitGatewayRouteTableAssociation.Builder> result = TransitGatewayRouteTableAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder associations(Collection<TransitGatewayRouteTableAssociation> associations) {
            this.associations = TransitGatewayRouteTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(TransitGatewayRouteTableAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<TransitGatewayRouteTableAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (TransitGatewayRouteTableAssociation)((TransitGatewayRouteTableAssociation.Builder)TransitGatewayRouteTableAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociations(Collection<TransitGatewayRouteTableAssociation.BuilderImpl> associations) {
            this.associations = TransitGatewayRouteTableAssociationListCopier.copyFromBuilder(associations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTransitGatewayRouteTableAssociationsResponse build() {
            return new GetTransitGatewayRouteTableAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayRouteTableAssociationsResponse> {
        public Builder associations(Collection<TransitGatewayRouteTableAssociation> var1);

        public Builder associations(TransitGatewayRouteTableAssociation ... var1);

        public Builder associations(Consumer<TransitGatewayRouteTableAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

