/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FleetData;
import software.amazon.awssdk.services.ec2.model.FleetSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFleetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetsResponse.getter(DescribeFleetsResponse::nextToken)).setter(DescribeFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<FleetData>> FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fleets").getter(DescribeFleetsResponse.getter(DescribeFleetsResponse::fleets)).setter(DescribeFleetsResponse.setter(Builder::fleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetSet").unmarshallLocationName("fleetSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FLEETS_FIELD));
    private final String nextToken;
    private final List<FleetData> fleets;

    private DescribeFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.fleets = builder.fleets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFleets() {
        return this.fleets != null && !(this.fleets instanceof SdkAutoConstructList);
    }

    public final List<FleetData> fleets() {
        return this.fleets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleets() ? this.fleets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsResponse)) {
            return false;
        }
        DescribeFleetsResponse other = (DescribeFleetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFleets() == other.hasFleets() && Objects.equals(this.fleets(), other.fleets());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetsResponse").add("NextToken", (Object)this.nextToken()).add("Fleets", this.hasFleets() ? this.fleets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Fleets": {
                return Optional.ofNullable(clazz.cast(this.fleets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetsResponse, T> g) {
        return obj -> g.apply((DescribeFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FleetData> fleets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.fleets(model.fleets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<FleetData.Builder> getFleets() {
            if (this.fleets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fleets != null ? (Collection)this.fleets.stream().map(FleetData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleets(Collection<FleetData> fleets) {
            this.fleets = FleetSetCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(FleetData ... fleets) {
            this.fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Consumer<FleetData.Builder> ... fleets) {
            this.fleets(Stream.of(fleets).map(c -> (FleetData)((FleetData.Builder)FleetData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFleets(Collection<FleetData.BuilderImpl> fleets) {
            this.fleets = FleetSetCopier.copyFromBuilder(fleets);
        }

        @Override
        public DescribeFleetsResponse build() {
            return new DescribeFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetsResponse> {
        public Builder nextToken(String var1);

        public Builder fleets(Collection<FleetData> var1);

        public Builder fleets(FleetData ... var1);

        public Builder fleets(Consumer<FleetData.Builder> ... var1);
    }
}

