/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.S3ObjectTag;
import software.amazon.awssdk.services.ec2.model.S3ObjectTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStoreImageTaskRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateStoreImageTaskRequest> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(CreateStoreImageTaskRequest.getter(CreateStoreImageTaskRequest::imageId)).setter(CreateStoreImageTaskRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(CreateStoreImageTaskRequest.getter(CreateStoreImageTaskRequest::bucket)).setter(CreateStoreImageTaskRequest.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<List<S3ObjectTag>> S3_OBJECT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3ObjectTags").getter(CreateStoreImageTaskRequest.getter(CreateStoreImageTaskRequest::s3ObjectTags)).setter(CreateStoreImageTaskRequest.setter(Builder::s3ObjectTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectTag").unmarshallLocationName("S3ObjectTag").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3ObjectTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, BUCKET_FIELD, S3_OBJECT_TAGS_FIELD));
    private final String imageId;
    private final String bucket;
    private final List<S3ObjectTag> s3ObjectTags;

    private CreateStoreImageTaskRequest(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.bucket = builder.bucket;
        this.s3ObjectTags = builder.s3ObjectTags;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final boolean hasS3ObjectTags() {
        return this.s3ObjectTags != null && !(this.s3ObjectTags instanceof SdkAutoConstructList);
    }

    public final List<S3ObjectTag> s3ObjectTags() {
        return this.s3ObjectTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3ObjectTags() ? this.s3ObjectTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStoreImageTaskRequest)) {
            return false;
        }
        CreateStoreImageTaskRequest other = (CreateStoreImageTaskRequest)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.bucket(), other.bucket()) && this.hasS3ObjectTags() == other.hasS3ObjectTags() && Objects.equals(this.s3ObjectTags(), other.s3ObjectTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStoreImageTaskRequest").add("ImageId", (Object)this.imageId()).add("Bucket", (Object)this.bucket()).add("S3ObjectTags", this.hasS3ObjectTags() ? this.s3ObjectTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "S3ObjectTags": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStoreImageTaskRequest, T> g) {
        return obj -> g.apply((CreateStoreImageTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String imageId;
        private String bucket;
        private List<S3ObjectTag> s3ObjectTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStoreImageTaskRequest model) {
            super(model);
            this.imageId(model.imageId);
            this.bucket(model.bucket);
            this.s3ObjectTags(model.s3ObjectTags);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final Collection<S3ObjectTag.Builder> getS3ObjectTags() {
            if (this.s3ObjectTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3ObjectTags != null ? (Collection)this.s3ObjectTags.stream().map(S3ObjectTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3ObjectTags(Collection<S3ObjectTag> s3ObjectTags) {
            this.s3ObjectTags = S3ObjectTagListCopier.copy(s3ObjectTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ObjectTags(S3ObjectTag ... s3ObjectTags) {
            this.s3ObjectTags(Arrays.asList(s3ObjectTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ObjectTags(Consumer<S3ObjectTag.Builder> ... s3ObjectTags) {
            this.s3ObjectTags(Stream.of(s3ObjectTags).map(c -> (S3ObjectTag)((S3ObjectTag.Builder)S3ObjectTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3ObjectTags(Collection<S3ObjectTag.BuilderImpl> s3ObjectTags) {
            this.s3ObjectTags = S3ObjectTagListCopier.copyFromBuilder(s3ObjectTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStoreImageTaskRequest build() {
            return new CreateStoreImageTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStoreImageTaskRequest> {
        public Builder imageId(String var1);

        public Builder bucket(String var1);

        public Builder s3ObjectTags(Collection<S3ObjectTag> var1);

        public Builder s3ObjectTags(S3ObjectTag ... var1);

        public Builder s3ObjectTags(Consumer<S3ObjectTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

