/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotDateTimeRangeRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotDateTimeRangeRequest> {
    private static final SdkField<Instant> EARLIEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EarliestTime").getter(SlotDateTimeRangeRequest.getter(SlotDateTimeRangeRequest::earliestTime)).setter(SlotDateTimeRangeRequest.setter(Builder::earliestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestTime").unmarshallLocationName("EarliestTime").build()}).build();
    private static final SdkField<Instant> LATEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestTime").getter(SlotDateTimeRangeRequest.getter(SlotDateTimeRangeRequest::latestTime)).setter(SlotDateTimeRangeRequest.setter(Builder::latestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestTime").unmarshallLocationName("LatestTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EARLIEST_TIME_FIELD, LATEST_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant earliestTime;
    private final Instant latestTime;

    private SlotDateTimeRangeRequest(BuilderImpl builder) {
        this.earliestTime = builder.earliestTime;
        this.latestTime = builder.latestTime;
    }

    public final Instant earliestTime() {
        return this.earliestTime;
    }

    public final Instant latestTime() {
        return this.latestTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotDateTimeRangeRequest)) {
            return false;
        }
        SlotDateTimeRangeRequest other = (SlotDateTimeRangeRequest)obj;
        return Objects.equals(this.earliestTime(), other.earliestTime()) && Objects.equals(this.latestTime(), other.latestTime());
    }

    public final String toString() {
        return ToString.builder((String)"SlotDateTimeRangeRequest").add("EarliestTime", (Object)this.earliestTime()).add("LatestTime", (Object)this.latestTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EarliestTime": {
                return Optional.ofNullable(clazz.cast(this.earliestTime()));
            }
            case "LatestTime": {
                return Optional.ofNullable(clazz.cast(this.latestTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotDateTimeRangeRequest, T> g) {
        return obj -> g.apply((SlotDateTimeRangeRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant earliestTime;
        private Instant latestTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotDateTimeRangeRequest model) {
            this.earliestTime(model.earliestTime);
            this.latestTime(model.latestTime);
        }

        public final Instant getEarliestTime() {
            return this.earliestTime;
        }

        @Override
        public final Builder earliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
            return this;
        }

        public final void setEarliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
        }

        public final Instant getLatestTime() {
            return this.latestTime;
        }

        @Override
        public final Builder latestTime(Instant latestTime) {
            this.latestTime = latestTime;
            return this;
        }

        public final void setLatestTime(Instant latestTime) {
            this.latestTime = latestTime;
        }

        public SlotDateTimeRangeRequest build() {
            return new SlotDateTimeRangeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotDateTimeRangeRequest> {
        public Builder earliestTime(Instant var1);

        public Builder latestTime(Instant var1);
    }
}

