/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IdFormat;
import software.amazon.awssdk.services.ec2.model.IdFormatListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalIdFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrincipalIdFormat> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(PrincipalIdFormat.getter(PrincipalIdFormat::arn)).setter(PrincipalIdFormat.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("arn").build()}).build();
    private static final SdkField<List<IdFormat>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statuses").getter(PrincipalIdFormat.getter(PrincipalIdFormat::statuses)).setter(PrincipalIdFormat.setter(Builder::statuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSet").unmarshallLocationName("statusSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<IdFormat> statuses;

    private PrincipalIdFormat(BuilderImpl builder) {
        this.arn = builder.arn;
        this.statuses = builder.statuses;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<IdFormat> statuses() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalIdFormat)) {
            return false;
        }
        PrincipalIdFormat other = (PrincipalIdFormat)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statuses(), other.statuses());
    }

    public final String toString() {
        return ToString.builder((String)"PrincipalIdFormat").add("Arn", (Object)this.arn()).add("Statuses", this.hasStatuses() ? this.statuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrincipalIdFormat, T> g) {
        return obj -> g.apply((PrincipalIdFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<IdFormat> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalIdFormat model) {
            this.arn(model.arn);
            this.statuses(model.statuses);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<IdFormat.Builder> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses != null ? (Collection)this.statuses.stream().map(IdFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(Consumer<IdFormat.Builder> ... statuses) {
            this.statuses(Stream.of(statuses).map(c -> (IdFormat)((IdFormat.Builder)IdFormat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatuses(Collection<IdFormat.BuilderImpl> statuses) {
            this.statuses = IdFormatListCopier.copyFromBuilder(statuses);
        }

        public PrincipalIdFormat build() {
            return new PrincipalIdFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrincipalIdFormat> {
        public Builder arn(String var1);

        public Builder statuses(Collection<IdFormat> var1);

        public Builder statuses(IdFormat ... var1);

        public Builder statuses(Consumer<IdFormat.Builder> ... var1);
    }
}

