/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FlowLog;
import software.amazon.awssdk.services.ec2.model.FlowLogSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFlowLogsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFlowLogsResponse> {
    private static final SdkField<List<FlowLog>> FLOW_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FlowLogs").getter(DescribeFlowLogsResponse.getter(DescribeFlowLogsResponse::flowLogs)).setter(DescribeFlowLogsResponse.setter(Builder::flowLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogSet").unmarshallLocationName("flowLogSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFlowLogsResponse.getter(DescribeFlowLogsResponse::nextToken)).setter(DescribeFlowLogsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_LOGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<FlowLog> flowLogs;
    private final String nextToken;

    private DescribeFlowLogsResponse(BuilderImpl builder) {
        super(builder);
        this.flowLogs = builder.flowLogs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFlowLogs() {
        return this.flowLogs != null && !(this.flowLogs instanceof SdkAutoConstructList);
    }

    public final List<FlowLog> flowLogs() {
        return this.flowLogs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowLogs() ? this.flowLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowLogsResponse)) {
            return false;
        }
        DescribeFlowLogsResponse other = (DescribeFlowLogsResponse)((Object)obj);
        return this.hasFlowLogs() == other.hasFlowLogs() && Objects.equals(this.flowLogs(), other.flowLogs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFlowLogsResponse").add("FlowLogs", this.hasFlowLogs() ? this.flowLogs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowLogs": {
                return Optional.ofNullable(clazz.cast(this.flowLogs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowLogsResponse, T> g) {
        return obj -> g.apply((DescribeFlowLogsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<FlowLog> flowLogs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowLogsResponse model) {
            super(model);
            this.flowLogs(model.flowLogs);
            this.nextToken(model.nextToken);
        }

        public final Collection<FlowLog.Builder> getFlowLogs() {
            if (this.flowLogs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.flowLogs != null ? (Collection)this.flowLogs.stream().map(FlowLog::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder flowLogs(Collection<FlowLog> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copy(flowLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogs(FlowLog ... flowLogs) {
            this.flowLogs(Arrays.asList(flowLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogs(Consumer<FlowLog.Builder> ... flowLogs) {
            this.flowLogs(Stream.of(flowLogs).map(c -> (FlowLog)((FlowLog.Builder)FlowLog.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFlowLogs(Collection<FlowLog.BuilderImpl> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copyFromBuilder(flowLogs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFlowLogsResponse build() {
            return new DescribeFlowLogsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFlowLogsResponse> {
        public Builder flowLogs(Collection<FlowLog> var1);

        public Builder flowLogs(FlowLog ... var1);

        public Builder flowLogs(Consumer<FlowLog.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

