/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.PaymentOption;
import software.amazon.awssdk.services.ec2.model.ReservationState;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostReservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostReservation> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(HostReservation.getter(HostReservation::count)).setter(HostReservation.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("count").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(HostReservation.getter(HostReservation::currencyCodeAsString)).setter(HostReservation.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(HostReservation.getter(HostReservation::duration)).setter(HostReservation.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").unmarshallLocationName("duration").build()}).build();
    private static final SdkField<Instant> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("End").getter(HostReservation.getter(HostReservation::end)).setter(HostReservation.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").unmarshallLocationName("end").build()}).build();
    private static final SdkField<List<String>> HOST_ID_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostIdSet").getter(HostReservation.getter(HostReservation::hostIdSet)).setter(HostReservation.setter(Builder::hostIdSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIdSet").unmarshallLocationName("hostIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> HOST_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostReservationId").getter(HostReservation.getter(HostReservation::hostReservationId)).setter(HostReservation.setter(Builder::hostReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostReservationId").unmarshallLocationName("hostReservationId").build()}).build();
    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HourlyPrice").getter(HostReservation.getter(HostReservation::hourlyPrice)).setter(HostReservation.setter(Builder::hourlyPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice").unmarshallLocationName("hourlyPrice").build()}).build();
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(HostReservation.getter(HostReservation::instanceFamily)).setter(HostReservation.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("instanceFamily").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingId").getter(HostReservation.getter(HostReservation::offeringId)).setter(HostReservation.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").unmarshallLocationName("offeringId").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentOption").getter(HostReservation.getter(HostReservation::paymentOptionAsString)).setter(HostReservation.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").unmarshallLocationName("paymentOption").build()}).build();
    private static final SdkField<Instant> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Start").getter(HostReservation.getter(HostReservation::start)).setter(HostReservation.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").unmarshallLocationName("start").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(HostReservation.getter(HostReservation::stateAsString)).setter(HostReservation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> UPFRONT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontPrice").getter(HostReservation.getter(HostReservation::upfrontPrice)).setter(HostReservation.setter(Builder::upfrontPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontPrice").unmarshallLocationName("upfrontPrice").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(HostReservation.getter(HostReservation::tags)).setter(HostReservation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, CURRENCY_CODE_FIELD, DURATION_FIELD, END_FIELD, HOST_ID_SET_FIELD, HOST_RESERVATION_ID_FIELD, HOURLY_PRICE_FIELD, INSTANCE_FAMILY_FIELD, OFFERING_ID_FIELD, PAYMENT_OPTION_FIELD, START_FIELD, STATE_FIELD, UPFRONT_PRICE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer count;
    private final String currencyCode;
    private final Integer duration;
    private final Instant end;
    private final List<String> hostIdSet;
    private final String hostReservationId;
    private final String hourlyPrice;
    private final String instanceFamily;
    private final String offeringId;
    private final String paymentOption;
    private final Instant start;
    private final String state;
    private final String upfrontPrice;
    private final List<Tag> tags;

    private HostReservation(BuilderImpl builder) {
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.end = builder.end;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.start = builder.start;
        this.state = builder.state;
        this.upfrontPrice = builder.upfrontPrice;
        this.tags = builder.tags;
    }

    public final Integer count() {
        return this.count;
    }

    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Instant end() {
        return this.end;
    }

    public final boolean hasHostIdSet() {
        return this.hostIdSet != null && !(this.hostIdSet instanceof SdkAutoConstructList);
    }

    public final List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public final String hostReservationId() {
        return this.hostReservationId;
    }

    public final String hourlyPrice() {
        return this.hourlyPrice;
    }

    public final String instanceFamily() {
        return this.instanceFamily;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final Instant start() {
        return this.start;
    }

    public final ReservationState state() {
        return ReservationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String upfrontPrice() {
        return this.upfrontPrice;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostIdSet() ? this.hostIdSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostReservation)) {
            return false;
        }
        HostReservation other = (HostReservation)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.end(), other.end()) && this.hasHostIdSet() == other.hasHostIdSet() && Objects.equals(this.hostIdSet(), other.hostIdSet()) && Objects.equals(this.hostReservationId(), other.hostReservationId()) && Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.instanceFamily(), other.instanceFamily()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.upfrontPrice(), other.upfrontPrice()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"HostReservation").add("Count", (Object)this.count()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Duration", (Object)this.duration()).add("End", (Object)this.end()).add("HostIdSet", this.hasHostIdSet() ? this.hostIdSet() : null).add("HostReservationId", (Object)this.hostReservationId()).add("HourlyPrice", (Object)this.hourlyPrice()).add("InstanceFamily", (Object)this.instanceFamily()).add("OfferingId", (Object)this.offeringId()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("Start", (Object)this.start()).add("State", (Object)this.stateAsString()).add("UpfrontPrice", (Object)this.upfrontPrice()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "HostIdSet": {
                return Optional.ofNullable(clazz.cast(this.hostIdSet()));
            }
            case "HostReservationId": {
                return Optional.ofNullable(clazz.cast(this.hostReservationId()));
            }
            case "HourlyPrice": {
                return Optional.ofNullable(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "UpfrontPrice": {
                return Optional.ofNullable(clazz.cast(this.upfrontPrice()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostReservation, T> g) {
        return obj -> g.apply((HostReservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private String currencyCode;
        private Integer duration;
        private Instant end;
        private List<String> hostIdSet = DefaultSdkAutoConstructList.getInstance();
        private String hostReservationId;
        private String hourlyPrice;
        private String instanceFamily;
        private String offeringId;
        private String paymentOption;
        private Instant start;
        private String state;
        private String upfrontPrice;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HostReservation model) {
            this.count(model.count);
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.end(model.end);
            this.hostIdSet(model.hostIdSet);
            this.hostReservationId(model.hostReservationId);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceFamily(model.instanceFamily);
            this.offeringId(model.offeringId);
            this.paymentOption(model.paymentOption);
            this.start(model.start);
            this.state(model.state);
            this.upfrontPrice(model.upfrontPrice);
            this.tags(model.tags);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Instant getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final Collection<String> getHostIdSet() {
            if (this.hostIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Instant getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getUpfrontPrice() {
            return this.upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public HostReservation build() {
            return new HostReservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostReservation> {
        public Builder count(Integer var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder duration(Integer var1);

        public Builder end(Instant var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder hostReservationId(String var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceFamily(String var1);

        public Builder offeringId(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder start(Instant var1);

        public Builder state(String var1);

        public Builder state(ReservationState var1);

        public Builder upfrontPrice(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

