/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the target configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetConfigurationRequest.Builder, TargetConfigurationRequest> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(TargetConfigurationRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OfferingId")
            .getter(getter(TargetConfigurationRequest::offeringId))
            .setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId")
                    .unmarshallLocationName("OfferingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD,
            OFFERING_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer instanceCount;

    private final String offeringId;

    private TargetConfigurationRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is reserved
     * and cannot be specified in a request
     * </p>
     * 
     * @return The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is
     *         reserved and cannot be specified in a request
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The Convertible Reserved Instance offering ID.
     * </p>
     * 
     * @return The Convertible Reserved Instance offering ID.
     */
    public final String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetConfigurationRequest)) {
            return false;
        }
        TargetConfigurationRequest other = (TargetConfigurationRequest) obj;
        return Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(offeringId(), other.offeringId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetConfigurationRequest").add("InstanceCount", instanceCount())
                .add("OfferingId", offeringId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetConfigurationRequest, T> g) {
        return obj -> g.apply((TargetConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetConfigurationRequest> {
        /**
         * <p>
         * The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is
         * reserved and cannot be specified in a request
         * </p>
         * 
         * @param instanceCount
         *        The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is
         *        reserved and cannot be specified in a request
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The Convertible Reserved Instance offering ID.
         * </p>
         * 
         * @param offeringId
         *        The Convertible Reserved Instance offering ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);
    }

    static final class BuilderImpl implements Builder {
        private Integer instanceCount;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetConfigurationRequest model) {
            instanceCount(model.instanceCount);
            offeringId(model.offeringId);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public TargetConfigurationRequest build() {
            return new TargetConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
