/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv6 address pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ipv6Pool implements SdkPojo, Serializable, ToCopyableBuilder<Ipv6Pool.Builder, Ipv6Pool> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PoolId")
            .getter(getter(Ipv6Pool::poolId))
            .setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId")
                    .unmarshallLocationName("poolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(Ipv6Pool::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<PoolCidrBlock>> POOL_CIDR_BLOCKS_FIELD = SdkField
            .<List<PoolCidrBlock>> builder(MarshallingType.LIST)
            .memberName("PoolCidrBlocks")
            .getter(getter(Ipv6Pool::poolCidrBlocks))
            .setter(setter(Builder::poolCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolCidrBlockSet")
                    .unmarshallLocationName("poolCidrBlockSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PoolCidrBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(PoolCidrBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Ipv6Pool::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD,
            DESCRIPTION_FIELD, POOL_CIDR_BLOCKS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String poolId;

    private final String description;

    private final List<PoolCidrBlock> poolCidrBlocks;

    private final List<Tag> tags;

    private Ipv6Pool(BuilderImpl builder) {
        this.poolId = builder.poolId;
        this.description = builder.description;
        this.poolCidrBlocks = builder.poolCidrBlocks;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the address pool.
     * </p>
     * 
     * @return The ID of the address pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The description for the address pool.
     * </p>
     * 
     * @return The description for the address pool.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the PoolCidrBlocks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPoolCidrBlocks() {
        return poolCidrBlocks != null && !(poolCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CIDR blocks for the address pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPoolCidrBlocks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The CIDR blocks for the address pool.
     */
    public final List<PoolCidrBlock> poolCidrBlocks() {
        return poolCidrBlocks;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags for the address pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags for the address pool.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPoolCidrBlocks() ? poolCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6Pool)) {
            return false;
        }
        Ipv6Pool other = (Ipv6Pool) obj;
        return Objects.equals(poolId(), other.poolId()) && Objects.equals(description(), other.description())
                && hasPoolCidrBlocks() == other.hasPoolCidrBlocks() && Objects.equals(poolCidrBlocks(), other.poolCidrBlocks())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ipv6Pool").add("PoolId", poolId()).add("Description", description())
                .add("PoolCidrBlocks", hasPoolCidrBlocks() ? poolCidrBlocks() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PoolCidrBlocks":
            return Optional.ofNullable(clazz.cast(poolCidrBlocks()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ipv6Pool, T> g) {
        return obj -> g.apply((Ipv6Pool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ipv6Pool> {
        /**
         * <p>
         * The ID of the address pool.
         * </p>
         * 
         * @param poolId
         *        The ID of the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The description for the address pool.
         * </p>
         * 
         * @param description
         *        The description for the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The CIDR blocks for the address pool.
         * </p>
         * 
         * @param poolCidrBlocks
         *        The CIDR blocks for the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolCidrBlocks(Collection<PoolCidrBlock> poolCidrBlocks);

        /**
         * <p>
         * The CIDR blocks for the address pool.
         * </p>
         * 
         * @param poolCidrBlocks
         *        The CIDR blocks for the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolCidrBlocks(PoolCidrBlock... poolCidrBlocks);

        /**
         * <p>
         * The CIDR blocks for the address pool.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PoolCidrBlock>.Builder} avoiding the need
         * to create one manually via {@link List<PoolCidrBlock>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PoolCidrBlock>.Builder#build()} is called immediately and
         * its result is passed to {@link #poolCidrBlocks(List<PoolCidrBlock>)}.
         * 
         * @param poolCidrBlocks
         *        a consumer that will call methods on {@link List<PoolCidrBlock>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #poolCidrBlocks(List<PoolCidrBlock>)
         */
        Builder poolCidrBlocks(Consumer<PoolCidrBlock.Builder>... poolCidrBlocks);

        /**
         * <p>
         * Any tags for the address pool.
         * </p>
         * 
         * @param tags
         *        Any tags for the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags for the address pool.
         * </p>
         * 
         * @param tags
         *        Any tags for the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags for the address pool.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String poolId;

        private String description;

        private List<PoolCidrBlock> poolCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv6Pool model) {
            poolId(model.poolId);
            description(model.description);
            poolCidrBlocks(model.poolCidrBlocks);
            tags(model.tags);
        }

        public final String getPoolId() {
            return poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<PoolCidrBlock.Builder> getPoolCidrBlocks() {
            if (poolCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return poolCidrBlocks != null ? poolCidrBlocks.stream().map(PoolCidrBlock::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder poolCidrBlocks(Collection<PoolCidrBlock> poolCidrBlocks) {
            this.poolCidrBlocks = PoolCidrBlocksSetCopier.copy(poolCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolCidrBlocks(PoolCidrBlock... poolCidrBlocks) {
            poolCidrBlocks(Arrays.asList(poolCidrBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolCidrBlocks(Consumer<PoolCidrBlock.Builder>... poolCidrBlocks) {
            poolCidrBlocks(Stream.of(poolCidrBlocks).map(c -> PoolCidrBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPoolCidrBlocks(Collection<PoolCidrBlock.BuilderImpl> poolCidrBlocks) {
            this.poolCidrBlocks = PoolCidrBlocksSetCopier.copyFromBuilder(poolCidrBlocks);
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Ipv6Pool build() {
            return new Ipv6Pool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
