/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFleetsRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteFleetsRequest.Builder, DeleteFleetsRequest> {
    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FleetIds")
            .getter(getter(DeleteFleetsRequest::fleetIds))
            .setter(setter(Builder::fleetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("FleetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminateInstances")
            .getter(getter(DeleteFleetsRequest::terminateInstances))
            .setter(setter(Builder::terminateInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstances")
                    .unmarshallLocationName("TerminateInstances").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_IDS_FIELD,
            TERMINATE_INSTANCES_FIELD));

    private final List<String> fleetIds;

    private final Boolean terminateInstances;

    private DeleteFleetsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetIds = builder.fleetIds;
        this.terminateInstances = builder.terminateInstances;
    }

    /**
     * Returns true if the FleetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFleetIds() {
        return fleetIds != null && !(fleetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the EC2 Fleets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFleetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the EC2 Fleets.
     */
    public final List<String> fleetIds() {
        return fleetIds;
    }

    /**
     * <p>
     * Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to terminate the
     * instances.
     * </p>
     * <p>
     * To let the instances continue to run after the EC2 Fleet is deleted, specify <code>NoTerminateInstances</code>.
     * Supported only for fleets of type <code>maintain</code> and <code>request</code>.
     * </p>
     * <p>
     * For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * 
     * @return Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to terminate
     *         the instances.</p>
     *         <p>
     *         To let the instances continue to run after the EC2 Fleet is deleted, specify
     *         <code>NoTerminateInstances</code>. Supported only for fleets of type <code>maintain</code> and
     *         <code>request</code>.
     *         </p>
     *         <p>
     *         For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A deleted
     *         <code>instant</code> fleet with running instances is not supported.
     */
    public final Boolean terminateInstances() {
        return terminateInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetIds() ? fleetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstances());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetsRequest)) {
            return false;
        }
        DeleteFleetsRequest other = (DeleteFleetsRequest) obj;
        return hasFleetIds() == other.hasFleetIds() && Objects.equals(fleetIds(), other.fleetIds())
                && Objects.equals(terminateInstances(), other.terminateInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFleetsRequest").add("FleetIds", hasFleetIds() ? fleetIds() : null)
                .add("TerminateInstances", terminateInstances()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetIds":
            return Optional.ofNullable(clazz.cast(fleetIds()));
        case "TerminateInstances":
            return Optional.ofNullable(clazz.cast(terminateInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetsRequest, T> g) {
        return obj -> g.apply((DeleteFleetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFleetsRequest> {
        /**
         * <p>
         * The IDs of the EC2 Fleets.
         * </p>
         * 
         * @param fleetIds
         *        The IDs of the EC2 Fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(Collection<String> fleetIds);

        /**
         * <p>
         * The IDs of the EC2 Fleets.
         * </p>
         * 
         * @param fleetIds
         *        The IDs of the EC2 Fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(String... fleetIds);

        /**
         * <p>
         * Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to terminate the
         * instances.
         * </p>
         * <p>
         * To let the instances continue to run after the EC2 Fleet is deleted, specify
         * <code>NoTerminateInstances</code>. Supported only for fleets of type <code>maintain</code> and
         * <code>request</code>.
         * </p>
         * <p>
         * For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A deleted
         * <code>instant</code> fleet with running instances is not supported.
         * </p>
         * 
         * @param terminateInstances
         *        Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to
         *        terminate the instances.</p>
         *        <p>
         *        To let the instances continue to run after the EC2 Fleet is deleted, specify
         *        <code>NoTerminateInstances</code>. Supported only for fleets of type <code>maintain</code> and
         *        <code>request</code>.
         *        </p>
         *        <p>
         *        For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A deleted
         *        <code>instant</code> fleet with running instances is not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstances(Boolean terminateInstances);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean terminateInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetsRequest model) {
            super(model);
            fleetIds(model.fleetIds);
            terminateInstances(model.terminateInstances);
        }

        public final Collection<String> getFleetIds() {
            if (fleetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return fleetIds;
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String... fleetIds) {
            fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = FleetIdSetCopier.copy(fleetIds);
        }

        public final Boolean getTerminateInstances() {
            return terminateInstances;
        }

        @Override
        public final Builder terminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
            return this;
        }

        public final void setTerminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFleetsRequest build() {
            return new DeleteFleetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
