/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisSecurityGroupRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisSecurityGroupRule.Builder, AnalysisSecurityGroupRule> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(AnalysisSecurityGroupRule::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("cidr").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Direction")
            .getter(getter(AnalysisSecurityGroupRule::direction))
            .setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction")
                    .unmarshallLocationName("direction").build()).build();

    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupId")
            .getter(getter(AnalysisSecurityGroupRule::securityGroupId))
            .setter(setter(Builder::securityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("securityGroupId").build()).build();

    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField
            .<PortRange> builder(MarshallingType.SDK_POJO)
            .memberName("PortRange")
            .getter(getter(AnalysisSecurityGroupRule::portRange))
            .setter(setter(Builder::portRange))
            .constructor(PortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange")
                    .unmarshallLocationName("portRange").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(AnalysisSecurityGroupRule::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(AnalysisSecurityGroupRule::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, DIRECTION_FIELD,
            SECURITY_GROUP_ID_FIELD, PORT_RANGE_FIELD, PREFIX_LIST_ID_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String direction;

    private final String securityGroupId;

    private final PortRange portRange;

    private final String prefixListId;

    private final String protocol;

    private AnalysisSecurityGroupRule(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.direction = builder.direction;
        this.securityGroupId = builder.securityGroupId;
        this.portRange = builder.portRange;
        this.prefixListId = builder.prefixListId;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The direction. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * egress
     * </p>
     * </li>
     * <li>
     * <p>
     * ingress
     * </p>
     * </li>
     * </ul>
     * 
     * @return The direction. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         egress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ingress
     *         </p>
     *         </li>
     */
    public final String direction() {
        return direction;
    }

    /**
     * <p>
     * The security group ID.
     * </p>
     * 
     * @return The security group ID.
     */
    public final String securityGroupId() {
        return securityGroupId;
    }

    /**
     * <p>
     * The port range.
     * </p>
     * 
     * @return The port range.
     */
    public final PortRange portRange() {
        return portRange;
    }

    /**
     * <p>
     * The prefix list ID.
     * </p>
     * 
     * @return The prefix list ID.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The protocol name.
     * </p>
     * 
     * @return The protocol name.
     */
    public final String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(direction());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(portRange());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSecurityGroupRule)) {
            return false;
        }
        AnalysisSecurityGroupRule other = (AnalysisSecurityGroupRule) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(direction(), other.direction())
                && Objects.equals(securityGroupId(), other.securityGroupId()) && Objects.equals(portRange(), other.portRange())
                && Objects.equals(prefixListId(), other.prefixListId()) && Objects.equals(protocol(), other.protocol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisSecurityGroupRule").add("Cidr", cidr()).add("Direction", direction())
                .add("SecurityGroupId", securityGroupId()).add("PortRange", portRange()).add("PrefixListId", prefixListId())
                .add("Protocol", protocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(direction()));
        case "SecurityGroupId":
            return Optional.ofNullable(clazz.cast(securityGroupId()));
        case "PortRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSecurityGroupRule, T> g) {
        return obj -> g.apply((AnalysisSecurityGroupRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisSecurityGroupRule> {
        /**
         * <p>
         * The IPv4 address range, in CIDR notation.
         * </p>
         * 
         * @param cidr
         *        The IPv4 address range, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The direction. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * egress
         * </p>
         * </li>
         * <li>
         * <p>
         * ingress
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        The direction. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        egress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ingress
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder direction(String direction);

        /**
         * <p>
         * The security group ID.
         * </p>
         * 
         * @param securityGroupId
         *        The security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupId(String securityGroupId);

        /**
         * <p>
         * The port range.
         * </p>
         * 
         * @param portRange
         *        The port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRange portRange);

        /**
         * <p>
         * The port range.
         * </p>
         * This is a convenience that creates an instance of the {@link PortRange.Builder} avoiding the need to create
         * one manually via {@link PortRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortRange.Builder#build()} is called immediately and its result
         * is passed to {@link #portRange(PortRange)}.
         * 
         * @param portRange
         *        a consumer that will call methods on {@link PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(PortRange)
         */
        default Builder portRange(Consumer<PortRange.Builder> portRange) {
            return portRange(PortRange.builder().applyMutation(portRange).build());
        }

        /**
         * <p>
         * The prefix list ID.
         * </p>
         * 
         * @param prefixListId
         *        The prefix list ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The protocol name.
         * </p>
         * 
         * @param protocol
         *        The protocol name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String direction;

        private String securityGroupId;

        private PortRange portRange;

        private String prefixListId;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSecurityGroupRule model) {
            cidr(model.cidr);
            direction(model.direction);
            securityGroupId(model.securityGroupId);
            portRange(model.portRange);
            prefixListId(model.prefixListId);
            protocol(model.protocol);
        }

        public final String getCidr() {
            return cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public final String getDirection() {
            return direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        public final String getSecurityGroupId() {
            return securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public final PortRange.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public AnalysisSecurityGroupRule build() {
            return new AnalysisSecurityGroupRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
