/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsInstanceBlockDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsInstanceBlockDevice> {
    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AttachTime").getter(EbsInstanceBlockDevice.getter(EbsInstanceBlockDevice::attachTime)).setter(EbsInstanceBlockDevice.setter(Builder::attachTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").unmarshallLocationName("attachTime").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(EbsInstanceBlockDevice.getter(EbsInstanceBlockDevice::deleteOnTermination)).setter(EbsInstanceBlockDevice.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EbsInstanceBlockDevice.getter(EbsInstanceBlockDevice::statusAsString)).setter(EbsInstanceBlockDevice.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(EbsInstanceBlockDevice.getter(EbsInstanceBlockDevice::volumeId)).setter(EbsInstanceBlockDevice.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TIME_FIELD, DELETE_ON_TERMINATION_FIELD, STATUS_FIELD, VOLUME_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant attachTime;
    private final Boolean deleteOnTermination;
    private final String status;
    private final String volumeId;

    private EbsInstanceBlockDevice(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.status = builder.status;
        this.volumeId = builder.volumeId;
    }

    public final Instant attachTime() {
        return this.attachTime;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsInstanceBlockDevice)) {
            return false;
        }
        EbsInstanceBlockDevice other = (EbsInstanceBlockDevice)obj;
        return Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public final String toString() {
        return ToString.builder((String)"EbsInstanceBlockDevice").add("AttachTime", (Object)this.attachTime()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Status", (Object)this.statusAsString()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachTime": {
                return Optional.ofNullable(clazz.cast(this.attachTime()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsInstanceBlockDevice, T> g) {
        return obj -> g.apply((EbsInstanceBlockDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private Boolean deleteOnTermination;
        private String status;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsInstanceBlockDevice model) {
            this.attachTime(model.attachTime);
            this.deleteOnTermination(model.deleteOnTermination);
            this.status(model.status);
            this.volumeId(model.volumeId);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public EbsInstanceBlockDevice build() {
            return new EbsInstanceBlockDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsInstanceBlockDevice> {
        public Builder attachTime(Instant var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);

        public Builder volumeId(String var1);
    }
}

