/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchSpecification> {
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(LaunchSpecification.getter(LaunchSpecification::userData)).setter(LaunchSpecification.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("userData").build()}).build();
    private static final SdkField<List<GroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(LaunchSpecification.getter(LaunchSpecification::securityGroups)).setter(LaunchSpecification.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> ADDRESSING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressingType").getter(LaunchSpecification.getter(LaunchSpecification::addressingType)).setter(LaunchSpecification.setter(Builder::addressingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressingType").unmarshallLocationName("addressingType").build()}).build();
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(LaunchSpecification.getter(LaunchSpecification::blockDeviceMappings)).setter(LaunchSpecification.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(LaunchSpecification.getter(LaunchSpecification::ebsOptimized)).setter(LaunchSpecification.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<IamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(LaunchSpecification.getter(LaunchSpecification::iamInstanceProfile)).setter(LaunchSpecification.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfileSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("iamInstanceProfile").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(LaunchSpecification.getter(LaunchSpecification::imageId)).setter(LaunchSpecification.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(LaunchSpecification.getter(LaunchSpecification::instanceTypeAsString)).setter(LaunchSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(LaunchSpecification.getter(LaunchSpecification::kernelId)).setter(LaunchSpecification.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("kernelId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(LaunchSpecification.getter(LaunchSpecification::keyName)).setter(LaunchSpecification.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final SdkField<List<InstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(LaunchSpecification.getter(LaunchSpecification::networkInterfaces)).setter(LaunchSpecification.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet").unmarshallLocationName("networkInterfaceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceNetworkInterfaceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<SpotPlacement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(LaunchSpecification.getter(LaunchSpecification::placement)).setter(LaunchSpecification.setter(Builder::placement)).constructor(SpotPlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("placement").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(LaunchSpecification.getter(LaunchSpecification::ramdiskId)).setter(LaunchSpecification.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").unmarshallLocationName("ramdiskId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(LaunchSpecification.getter(LaunchSpecification::subnetId)).setter(LaunchSpecification.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<RunInstancesMonitoringEnabled> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(LaunchSpecification.getter(LaunchSpecification::monitoring)).setter(LaunchSpecification.setter(Builder::monitoring)).constructor(RunInstancesMonitoringEnabled::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("monitoring").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DATA_FIELD, SECURITY_GROUPS_FIELD, ADDRESSING_TYPE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD, NETWORK_INTERFACES_FIELD, PLACEMENT_FIELD, RAMDISK_ID_FIELD, SUBNET_ID_FIELD, MONITORING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userData;
    private final List<GroupIdentifier> securityGroups;
    private final String addressingType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final SpotPlacement placement;
    private final String ramdiskId;
    private final String subnetId;
    private final RunInstancesMonitoringEnabled monitoring;

    private LaunchSpecification(BuilderImpl builder) {
        this.userData = builder.userData;
        this.securityGroups = builder.securityGroups;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.subnetId = builder.subnetId;
        this.monitoring = builder.monitoring;
    }

    public String userData() {
        return this.userData;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public List<GroupIdentifier> securityGroups() {
        return this.securityGroups;
    }

    public String addressingType() {
        return this.addressingType;
    }

    public boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String imageId() {
        return this.imageId;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public SpotPlacement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public RunInstancesMonitoringEnabled monitoring() {
        return this.monitoring;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressingType());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchSpecification)) {
            return false;
        }
        LaunchSpecification other = (LaunchSpecification)obj;
        return Objects.equals(this.userData(), other.userData()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.addressingType(), other.addressingType()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.monitoring(), other.monitoring());
    }

    public String toString() {
        return ToString.builder((String)"LaunchSpecification").add("UserData", (Object)this.userData()).add("SecurityGroups", this.securityGroups()).add("AddressingType", (Object)this.addressingType()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KernelId", (Object)this.kernelId()).add("KeyName", (Object)this.keyName()).add("NetworkInterfaces", this.networkInterfaces()).add("Placement", (Object)this.placement()).add("RamdiskId", (Object)this.ramdiskId()).add("SubnetId", (Object)this.subnetId()).add("Monitoring", (Object)this.monitoring()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "AddressingType": {
                return Optional.ofNullable(clazz.cast(this.addressingType()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchSpecification, T> g) {
        return obj -> g.apply((LaunchSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userData;
        private List<GroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String addressingType;
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private SpotPlacement placement;
        private String ramdiskId;
        private String subnetId;
        private RunInstancesMonitoringEnabled monitoring;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchSpecification model) {
            this.userData(model.userData);
            this.securityGroups(model.securityGroups);
            this.addressingType(model.addressingType);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.keyName(model.keyName);
            this.networkInterfaces(model.networkInterfaces);
            this.placement(model.placement);
            this.ramdiskId(model.ramdiskId);
            this.subnetId(model.subnetId);
            this.monitoring(model.monitoring);
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final Collection<GroupIdentifier.Builder> getSecurityGroups() {
            return this.securityGroups != null ? (Collection)this.securityGroups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<GroupIdentifier.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        public final String getAddressingType() {
            return this.addressingType;
        }

        @Override
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            return this.networkInterfaces != null ? (Collection)this.networkInterfaces.stream().map(InstanceNetworkInterfaceSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (InstanceNetworkInterfaceSpecification)((InstanceNetworkInterfaceSpecification.Builder)InstanceNetworkInterfaceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        public final SpotPlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(SpotPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final RunInstancesMonitoringEnabled.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(RunInstancesMonitoringEnabled monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(RunInstancesMonitoringEnabled.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public LaunchSpecification build() {
            return new LaunchSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchSpecification> {
        public Builder userData(String var1);

        public Builder securityGroups(Collection<GroupIdentifier> var1);

        public Builder securityGroups(GroupIdentifier ... var1);

        public Builder securityGroups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder addressingType(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileSpecification)((IamInstanceProfileSpecification.Builder)IamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<InstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder placement(SpotPlacement var1);

        default public Builder placement(Consumer<SpotPlacement.Builder> placement) {
            return this.placement((SpotPlacement)((SpotPlacement.Builder)SpotPlacement.builder().applyMutation(placement)).build());
        }

        public Builder ramdiskId(String var1);

        public Builder subnetId(String var1);

        public Builder monitoring(RunInstancesMonitoringEnabled var1);

        default public Builder monitoring(Consumer<RunInstancesMonitoringEnabled.Builder> monitoring) {
            return this.monitoring((RunInstancesMonitoringEnabled)((RunInstancesMonitoringEnabled.Builder)RunInstancesMonitoringEnabled.builder().applyMutation(monitoring)).build());
        }
    }
}

