/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreStateErrorItem;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreStateErrorSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableFastSnapshotRestoreErrorItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnableFastSnapshotRestoreErrorItem> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(EnableFastSnapshotRestoreErrorItem.getter(EnableFastSnapshotRestoreErrorItem::snapshotId)).setter(EnableFastSnapshotRestoreErrorItem.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<List<EnableFastSnapshotRestoreStateErrorItem>> FAST_SNAPSHOT_RESTORE_STATE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FastSnapshotRestoreStateErrors").getter(EnableFastSnapshotRestoreErrorItem.getter(EnableFastSnapshotRestoreErrorItem::fastSnapshotRestoreStateErrors)).setter(EnableFastSnapshotRestoreErrorItem.setter(Builder::fastSnapshotRestoreStateErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastSnapshotRestoreStateErrorSet").unmarshallLocationName("fastSnapshotRestoreStateErrorSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnableFastSnapshotRestoreStateErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, FAST_SNAPSHOT_RESTORE_STATE_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snapshotId;
    private final List<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors;

    private EnableFastSnapshotRestoreErrorItem(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.fastSnapshotRestoreStateErrors = builder.fastSnapshotRestoreStateErrors;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final boolean hasFastSnapshotRestoreStateErrors() {
        return this.fastSnapshotRestoreStateErrors != null && !(this.fastSnapshotRestoreStateErrors instanceof SdkAutoConstructList);
    }

    public final List<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors() {
        return this.fastSnapshotRestoreStateErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFastSnapshotRestoreStateErrors() ? this.fastSnapshotRestoreStateErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoreErrorItem)) {
            return false;
        }
        EnableFastSnapshotRestoreErrorItem other = (EnableFastSnapshotRestoreErrorItem)obj;
        return Objects.equals(this.snapshotId(), other.snapshotId()) && this.hasFastSnapshotRestoreStateErrors() == other.hasFastSnapshotRestoreStateErrors() && Objects.equals(this.fastSnapshotRestoreStateErrors(), other.fastSnapshotRestoreStateErrors());
    }

    public final String toString() {
        return ToString.builder((String)"EnableFastSnapshotRestoreErrorItem").add("SnapshotId", (Object)this.snapshotId()).add("FastSnapshotRestoreStateErrors", this.hasFastSnapshotRestoreStateErrors() ? this.fastSnapshotRestoreStateErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "FastSnapshotRestoreStateErrors": {
                return Optional.ofNullable(clazz.cast(this.fastSnapshotRestoreStateErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoreErrorItem, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoreErrorItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotId;
        private List<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoreErrorItem model) {
            this.snapshotId(model.snapshotId);
            this.fastSnapshotRestoreStateErrors(model.fastSnapshotRestoreStateErrors);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Collection<EnableFastSnapshotRestoreStateErrorItem.Builder> getFastSnapshotRestoreStateErrors() {
            if (this.fastSnapshotRestoreStateErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fastSnapshotRestoreStateErrors != null ? (Collection)this.fastSnapshotRestoreStateErrors.stream().map(EnableFastSnapshotRestoreStateErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fastSnapshotRestoreStateErrors(Collection<EnableFastSnapshotRestoreStateErrorItem> fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors = EnableFastSnapshotRestoreStateErrorSetCopier.copy(fastSnapshotRestoreStateErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestoreStateErrors(EnableFastSnapshotRestoreStateErrorItem ... fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors(Arrays.asList(fastSnapshotRestoreStateErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestoreStateErrors(Consumer<EnableFastSnapshotRestoreStateErrorItem.Builder> ... fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors(Stream.of(fastSnapshotRestoreStateErrors).map(c -> (EnableFastSnapshotRestoreStateErrorItem)((EnableFastSnapshotRestoreStateErrorItem.Builder)EnableFastSnapshotRestoreStateErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFastSnapshotRestoreStateErrors(Collection<EnableFastSnapshotRestoreStateErrorItem.BuilderImpl> fastSnapshotRestoreStateErrors) {
            this.fastSnapshotRestoreStateErrors = EnableFastSnapshotRestoreStateErrorSetCopier.copyFromBuilder(fastSnapshotRestoreStateErrors);
        }

        public EnableFastSnapshotRestoreErrorItem build() {
            return new EnableFastSnapshotRestoreErrorItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnableFastSnapshotRestoreErrorItem> {
        public Builder snapshotId(String var1);

        public Builder fastSnapshotRestoreStateErrors(Collection<EnableFastSnapshotRestoreStateErrorItem> var1);

        public Builder fastSnapshotRestoreStateErrors(EnableFastSnapshotRestoreStateErrorItem ... var1);

        public Builder fastSnapshotRestoreStateErrors(Consumer<EnableFastSnapshotRestoreStateErrorItem.Builder> ... var1);
    }
}

