/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName;
import software.amazon.awssdk.services.ec2.model.LoadPermissionModifications;
import software.amazon.awssdk.services.ec2.model.OperationType;
import software.amazon.awssdk.services.ec2.model.ProductCodeStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyFpgaImageAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyFpgaImageAttributeRequest> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FpgaImageId").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::fpgaImageId)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::fpgaImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId").unmarshallLocationName("FpgaImageId").build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::attributeAsString)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").unmarshallLocationName("Attribute").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationType").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::operationTypeAsString)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType").unmarshallLocationName("OperationType").build()}).build();
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIds").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::userIds)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("UserId").build(), ListTrait.builder().memberLocationName("UserId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("UserId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserGroups").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::userGroups)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::userGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").unmarshallLocationName("UserGroup").build(), ListTrait.builder().memberLocationName("UserGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").unmarshallLocationName("UserGroup").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::productCodes)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").unmarshallLocationName("ProductCode").build(), ListTrait.builder().memberLocationName("ProductCode").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").unmarshallLocationName("ProductCode").build()}).build()).build()}).build();
    private static final SdkField<LoadPermissionModifications> LOAD_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadPermission").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::loadPermission)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::loadPermission)).constructor(LoadPermissionModifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadPermission").unmarshallLocationName("LoadPermission").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::description)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ModifyFpgaImageAttributeRequest.getter(ModifyFpgaImageAttributeRequest::name)).setter(ModifyFpgaImageAttributeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD, ATTRIBUTE_FIELD, OPERATION_TYPE_FIELD, USER_IDS_FIELD, USER_GROUPS_FIELD, PRODUCT_CODES_FIELD, LOAD_PERMISSION_FIELD, DESCRIPTION_FIELD, NAME_FIELD));
    private final String fpgaImageId;
    private final String attribute;
    private final String operationType;
    private final List<String> userIds;
    private final List<String> userGroups;
    private final List<String> productCodes;
    private final LoadPermissionModifications loadPermission;
    private final String description;
    private final String name;

    private ModifyFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
        this.operationType = builder.operationType;
        this.userIds = builder.userIds;
        this.userGroups = builder.userGroups;
        this.productCodes = builder.productCodes;
        this.loadPermission = builder.loadPermission;
        this.description = builder.description;
        this.name = builder.name;
    }

    public final String fpgaImageId() {
        return this.fpgaImageId;
    }

    public final FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final boolean hasUserGroups() {
        return this.userGroups != null && !(this.userGroups instanceof SdkAutoConstructList);
    }

    public final List<String> userGroups() {
        return this.userGroups;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<String> productCodes() {
        return this.productCodes;
    }

    public final LoadPermissionModifications loadPermission() {
        return this.loadPermission;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroups() ? this.userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loadPermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFpgaImageAttributeRequest)) {
            return false;
        }
        ModifyFpgaImageAttributeRequest other = (ModifyFpgaImageAttributeRequest)((Object)obj);
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && this.hasUserGroups() == other.hasUserGroups() && Objects.equals(this.userGroups(), other.userGroups()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.loadPermission(), other.loadPermission()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyFpgaImageAttributeRequest").add("FpgaImageId", (Object)this.fpgaImageId()).add("Attribute", (Object)this.attributeAsString()).add("OperationType", (Object)this.operationTypeAsString()).add("UserIds", this.hasUserIds() ? this.userIds() : null).add("UserGroups", this.hasUserGroups() ? this.userGroups() : null).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("LoadPermission", (Object)this.loadPermission()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageId()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "UserGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "LoadPermission": {
                return Optional.ofNullable(clazz.cast(this.loadPermission()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyFpgaImageAttributeRequest, T> g) {
        return obj -> g.apply((ModifyFpgaImageAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String attribute;
        private String operationType;
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> productCodes = DefaultSdkAutoConstructList.getInstance();
        private LoadPermissionModifications loadPermission;
        private String description;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFpgaImageAttributeRequest model) {
            super(model);
            this.fpgaImageId(model.fpgaImageId);
            this.attribute(model.attribute);
            this.operationType(model.operationType);
            this.userIds(model.userIds);
            this.userGroups(model.userGroups);
            this.productCodes(model.productCodes);
            this.loadPermission(model.loadPermission);
            this.description(model.description);
            this.name(model.name);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        public final Collection<String> getUserGroups() {
            if (this.userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        public final Collection<String> getProductCodes() {
            if (this.productCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        public final LoadPermissionModifications.Builder getLoadPermission() {
            return this.loadPermission != null ? this.loadPermission.toBuilder() : null;
        }

        @Override
        public final Builder loadPermission(LoadPermissionModifications loadPermission) {
            this.loadPermission = loadPermission;
            return this;
        }

        public final void setLoadPermission(LoadPermissionModifications.BuilderImpl loadPermission) {
            this.loadPermission = loadPermission != null ? loadPermission.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyFpgaImageAttributeRequest build() {
            return new ModifyFpgaImageAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyFpgaImageAttributeRequest> {
        public Builder fpgaImageId(String var1);

        public Builder attribute(String var1);

        public Builder attribute(FpgaImageAttributeName var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);

        public Builder productCodes(Collection<String> var1);

        public Builder productCodes(String ... var1);

        public Builder loadPermission(LoadPermissionModifications var1);

        default public Builder loadPermission(Consumer<LoadPermissionModifications.Builder> loadPermission) {
            return this.loadPermission((LoadPermissionModifications)((LoadPermissionModifications.Builder)LoadPermissionModifications.builder().applyMutation(loadPermission)).build());
        }

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

