/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClientCertificateRevocationListStatus;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportClientVpnClientCertificateRevocationListResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ExportClientVpnClientCertificateRevocationListResponse> {
    private static final SdkField<String> CERTIFICATE_REVOCATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateRevocationList").getter(ExportClientVpnClientCertificateRevocationListResponse.getter(ExportClientVpnClientCertificateRevocationListResponse::certificateRevocationList)).setter(ExportClientVpnClientCertificateRevocationListResponse.setter(Builder::certificateRevocationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateRevocationList").unmarshallLocationName("certificateRevocationList").build()}).build();
    private static final SdkField<ClientCertificateRevocationListStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ExportClientVpnClientCertificateRevocationListResponse.getter(ExportClientVpnClientCertificateRevocationListResponse::status)).setter(ExportClientVpnClientCertificateRevocationListResponse.setter(Builder::status)).constructor(ClientCertificateRevocationListStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_REVOCATION_LIST_FIELD, STATUS_FIELD));
    private final String certificateRevocationList;
    private final ClientCertificateRevocationListStatus status;

    private ExportClientVpnClientCertificateRevocationListResponse(BuilderImpl builder) {
        super(builder);
        this.certificateRevocationList = builder.certificateRevocationList;
        this.status = builder.status;
    }

    public final String certificateRevocationList() {
        return this.certificateRevocationList;
    }

    public final ClientCertificateRevocationListStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateRevocationList());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportClientVpnClientCertificateRevocationListResponse)) {
            return false;
        }
        ExportClientVpnClientCertificateRevocationListResponse other = (ExportClientVpnClientCertificateRevocationListResponse)((Object)obj);
        return Objects.equals(this.certificateRevocationList(), other.certificateRevocationList()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ExportClientVpnClientCertificateRevocationListResponse").add("CertificateRevocationList", (Object)this.certificateRevocationList()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateRevocationList": {
                return Optional.ofNullable(clazz.cast(this.certificateRevocationList()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportClientVpnClientCertificateRevocationListResponse, T> g) {
        return obj -> g.apply((ExportClientVpnClientCertificateRevocationListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String certificateRevocationList;
        private ClientCertificateRevocationListStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportClientVpnClientCertificateRevocationListResponse model) {
            super(model);
            this.certificateRevocationList(model.certificateRevocationList);
            this.status(model.status);
        }

        public final String getCertificateRevocationList() {
            return this.certificateRevocationList;
        }

        @Override
        public final Builder certificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
            return this;
        }

        public final void setCertificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
        }

        public final ClientCertificateRevocationListStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClientCertificateRevocationListStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClientCertificateRevocationListStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public ExportClientVpnClientCertificateRevocationListResponse build() {
            return new ExportClientVpnClientCertificateRevocationListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportClientVpnClientCertificateRevocationListResponse> {
        public Builder certificateRevocationList(String var1);

        public Builder status(ClientCertificateRevocationListStatus var1);

        default public Builder status(Consumer<ClientCertificateRevocationListStatus.Builder> status) {
            return this.status((ClientCertificateRevocationListStatus)((ClientCertificateRevocationListStatus.Builder)ClientCertificateRevocationListStatus.builder().applyMutation(status)).build());
        }
    }
}

