/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;

public class DescribeReservedInstancesOfferingsIterable
implements SdkIterable<DescribeReservedInstancesOfferingsResponse> {
    private final Ec2Client client;
    private final DescribeReservedInstancesOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedInstancesOfferingsIterable(Ec2Client client, DescribeReservedInstancesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedInstancesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedInstancesOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedInstancesOffering> reservedInstancesOfferings() {
        Function<DescribeReservedInstancesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedInstancesOfferings() != null) {
                return response.reservedInstancesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedInstancesOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedInstancesOfferingsResponse> {
        private DescribeReservedInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReservedInstancesOfferingsResponse nextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesOfferingsIterable.this.client.describeReservedInstancesOfferings(DescribeReservedInstancesOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedInstancesOfferingsIterable.this.client.describeReservedInstancesOfferings((DescribeReservedInstancesOfferingsRequest)((Object)DescribeReservedInstancesOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

