/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;

public class DescribeVpcEndpointsIterable
implements SdkIterable<DescribeVpcEndpointsResponse> {
    private final Ec2Client client;
    private final DescribeVpcEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcEndpointsIterable(Ec2Client client, DescribeVpcEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVpcEndpointsResponseFetcher();
    }

    public Iterator<DescribeVpcEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VpcEndpoint> vpcEndpoints() {
        Function<DescribeVpcEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vpcEndpoints() != null) {
                return response.vpcEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeVpcEndpointsResponse> {
        private DescribeVpcEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcEndpointsResponse nextPage(DescribeVpcEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointsIterable.this.client.describeVpcEndpoints(DescribeVpcEndpointsIterable.this.firstRequest);
            }
            return DescribeVpcEndpointsIterable.this.client.describeVpcEndpoints((DescribeVpcEndpointsRequest)((Object)DescribeVpcEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

