/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CoreCountListCopier;
import software.amazon.awssdk.services.ec2.model.ThreadsPerCoreListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VCpuInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VCpuInfo> {
    private static final SdkField<Integer> DEFAULT_V_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultVCpus").getter(VCpuInfo.getter(VCpuInfo::defaultVCpus)).setter(VCpuInfo.setter(Builder::defaultVCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVCpus").unmarshallLocationName("defaultVCpus").build()}).build();
    private static final SdkField<Integer> DEFAULT_CORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultCores").getter(VCpuInfo.getter(VCpuInfo::defaultCores)).setter(VCpuInfo.setter(Builder::defaultCores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCores").unmarshallLocationName("defaultCores").build()}).build();
    private static final SdkField<Integer> DEFAULT_THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultThreadsPerCore").getter(VCpuInfo.getter(VCpuInfo::defaultThreadsPerCore)).setter(VCpuInfo.setter(Builder::defaultThreadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultThreadsPerCore").unmarshallLocationName("defaultThreadsPerCore").build()}).build();
    private static final SdkField<List<Integer>> VALID_CORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidCores").getter(VCpuInfo.getter(VCpuInfo::validCores)).setter(VCpuInfo.setter(Builder::validCores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidCores").unmarshallLocationName("validCores").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> VALID_THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidThreadsPerCore").getter(VCpuInfo.getter(VCpuInfo::validThreadsPerCore)).setter(VCpuInfo.setter(Builder::validThreadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidThreadsPerCore").unmarshallLocationName("validThreadsPerCore").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_V_CPUS_FIELD, DEFAULT_CORES_FIELD, DEFAULT_THREADS_PER_CORE_FIELD, VALID_CORES_FIELD, VALID_THREADS_PER_CORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer defaultVCpus;
    private final Integer defaultCores;
    private final Integer defaultThreadsPerCore;
    private final List<Integer> validCores;
    private final List<Integer> validThreadsPerCore;

    private VCpuInfo(BuilderImpl builder) {
        this.defaultVCpus = builder.defaultVCpus;
        this.defaultCores = builder.defaultCores;
        this.defaultThreadsPerCore = builder.defaultThreadsPerCore;
        this.validCores = builder.validCores;
        this.validThreadsPerCore = builder.validThreadsPerCore;
    }

    public Integer defaultVCpus() {
        return this.defaultVCpus;
    }

    public Integer defaultCores() {
        return this.defaultCores;
    }

    public Integer defaultThreadsPerCore() {
        return this.defaultThreadsPerCore;
    }

    public boolean hasValidCores() {
        return this.validCores != null && !(this.validCores instanceof SdkAutoConstructList);
    }

    public List<Integer> validCores() {
        return this.validCores;
    }

    public boolean hasValidThreadsPerCore() {
        return this.validThreadsPerCore != null && !(this.validThreadsPerCore instanceof SdkAutoConstructList);
    }

    public List<Integer> validThreadsPerCore() {
        return this.validThreadsPerCore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCores());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultThreadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidCores() ? this.validCores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidThreadsPerCore() ? this.validThreadsPerCore() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VCpuInfo)) {
            return false;
        }
        VCpuInfo other = (VCpuInfo)obj;
        return Objects.equals(this.defaultVCpus(), other.defaultVCpus()) && Objects.equals(this.defaultCores(), other.defaultCores()) && Objects.equals(this.defaultThreadsPerCore(), other.defaultThreadsPerCore()) && this.hasValidCores() == other.hasValidCores() && Objects.equals(this.validCores(), other.validCores()) && this.hasValidThreadsPerCore() == other.hasValidThreadsPerCore() && Objects.equals(this.validThreadsPerCore(), other.validThreadsPerCore());
    }

    public String toString() {
        return ToString.builder((String)"VCpuInfo").add("DefaultVCpus", (Object)this.defaultVCpus()).add("DefaultCores", (Object)this.defaultCores()).add("DefaultThreadsPerCore", (Object)this.defaultThreadsPerCore()).add("ValidCores", this.hasValidCores() ? this.validCores() : null).add("ValidThreadsPerCore", this.hasValidThreadsPerCore() ? this.validThreadsPerCore() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultVCpus": {
                return Optional.ofNullable(clazz.cast(this.defaultVCpus()));
            }
            case "DefaultCores": {
                return Optional.ofNullable(clazz.cast(this.defaultCores()));
            }
            case "DefaultThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.defaultThreadsPerCore()));
            }
            case "ValidCores": {
                return Optional.ofNullable(clazz.cast(this.validCores()));
            }
            case "ValidThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.validThreadsPerCore()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VCpuInfo, T> g) {
        return obj -> g.apply((VCpuInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer defaultVCpus;
        private Integer defaultCores;
        private Integer defaultThreadsPerCore;
        private List<Integer> validCores = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> validThreadsPerCore = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VCpuInfo model) {
            this.defaultVCpus(model.defaultVCpus);
            this.defaultCores(model.defaultCores);
            this.defaultThreadsPerCore(model.defaultThreadsPerCore);
            this.validCores(model.validCores);
            this.validThreadsPerCore(model.validThreadsPerCore);
        }

        public final Integer getDefaultVCpus() {
            return this.defaultVCpus;
        }

        @Override
        public final Builder defaultVCpus(Integer defaultVCpus) {
            this.defaultVCpus = defaultVCpus;
            return this;
        }

        public final void setDefaultVCpus(Integer defaultVCpus) {
            this.defaultVCpus = defaultVCpus;
        }

        public final Integer getDefaultCores() {
            return this.defaultCores;
        }

        @Override
        public final Builder defaultCores(Integer defaultCores) {
            this.defaultCores = defaultCores;
            return this;
        }

        public final void setDefaultCores(Integer defaultCores) {
            this.defaultCores = defaultCores;
        }

        public final Integer getDefaultThreadsPerCore() {
            return this.defaultThreadsPerCore;
        }

        @Override
        public final Builder defaultThreadsPerCore(Integer defaultThreadsPerCore) {
            this.defaultThreadsPerCore = defaultThreadsPerCore;
            return this;
        }

        public final void setDefaultThreadsPerCore(Integer defaultThreadsPerCore) {
            this.defaultThreadsPerCore = defaultThreadsPerCore;
        }

        public final Collection<Integer> getValidCores() {
            if (this.validCores instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validCores;
        }

        @Override
        public final Builder validCores(Collection<Integer> validCores) {
            this.validCores = CoreCountListCopier.copy(validCores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validCores(Integer ... validCores) {
            this.validCores(Arrays.asList(validCores));
            return this;
        }

        public final void setValidCores(Collection<Integer> validCores) {
            this.validCores = CoreCountListCopier.copy(validCores);
        }

        public final Collection<Integer> getValidThreadsPerCore() {
            if (this.validThreadsPerCore instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validThreadsPerCore;
        }

        @Override
        public final Builder validThreadsPerCore(Collection<Integer> validThreadsPerCore) {
            this.validThreadsPerCore = ThreadsPerCoreListCopier.copy(validThreadsPerCore);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validThreadsPerCore(Integer ... validThreadsPerCore) {
            this.validThreadsPerCore(Arrays.asList(validThreadsPerCore));
            return this;
        }

        public final void setValidThreadsPerCore(Collection<Integer> validThreadsPerCore) {
            this.validThreadsPerCore = ThreadsPerCoreListCopier.copy(validThreadsPerCore);
        }

        public VCpuInfo build() {
            return new VCpuInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VCpuInfo> {
        public Builder defaultVCpus(Integer var1);

        public Builder defaultCores(Integer var1);

        public Builder defaultThreadsPerCore(Integer var1);

        public Builder validCores(Collection<Integer> var1);

        public Builder validCores(Integer ... var1);

        public Builder validThreadsPerCore(Collection<Integer> var1);

        public Builder validThreadsPerCore(Integer ... var1);
    }
}

