/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ElasticGpuHealth;
import software.amazon.awssdk.services.ec2.model.ElasticGpuState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticGpus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticGpus> {
    private static final SdkField<String> ELASTIC_GPU_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticGpuId").getter(ElasticGpus.getter(ElasticGpus::elasticGpuId)).setter(ElasticGpus.setter(Builder::elasticGpuId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuId").unmarshallLocationName("elasticGpuId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ElasticGpus.getter(ElasticGpus::availabilityZone)).setter(ElasticGpus.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> ELASTIC_GPU_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticGpuType").getter(ElasticGpus.getter(ElasticGpus::elasticGpuType)).setter(ElasticGpus.setter(Builder::elasticGpuType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuType").unmarshallLocationName("elasticGpuType").build()}).build();
    private static final SdkField<ElasticGpuHealth> ELASTIC_GPU_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticGpuHealth").getter(ElasticGpus.getter(ElasticGpus::elasticGpuHealth)).setter(ElasticGpus.setter(Builder::elasticGpuHealth)).constructor(ElasticGpuHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuHealth").unmarshallLocationName("elasticGpuHealth").build()}).build();
    private static final SdkField<String> ELASTIC_GPU_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticGpuState").getter(ElasticGpus.getter(ElasticGpus::elasticGpuStateAsString)).setter(ElasticGpus.setter(Builder::elasticGpuState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuState").unmarshallLocationName("elasticGpuState").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ElasticGpus.getter(ElasticGpus::instanceId)).setter(ElasticGpus.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ElasticGpus.getter(ElasticGpus::tags)).setter(ElasticGpus.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_GPU_ID_FIELD, AVAILABILITY_ZONE_FIELD, ELASTIC_GPU_TYPE_FIELD, ELASTIC_GPU_HEALTH_FIELD, ELASTIC_GPU_STATE_FIELD, INSTANCE_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String elasticGpuId;
    private final String availabilityZone;
    private final String elasticGpuType;
    private final ElasticGpuHealth elasticGpuHealth;
    private final String elasticGpuState;
    private final String instanceId;
    private final List<Tag> tags;

    private ElasticGpus(BuilderImpl builder) {
        this.elasticGpuId = builder.elasticGpuId;
        this.availabilityZone = builder.availabilityZone;
        this.elasticGpuType = builder.elasticGpuType;
        this.elasticGpuHealth = builder.elasticGpuHealth;
        this.elasticGpuState = builder.elasticGpuState;
        this.instanceId = builder.instanceId;
        this.tags = builder.tags;
    }

    public String elasticGpuId() {
        return this.elasticGpuId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String elasticGpuType() {
        return this.elasticGpuType;
    }

    public ElasticGpuHealth elasticGpuHealth() {
        return this.elasticGpuHealth;
    }

    public ElasticGpuState elasticGpuState() {
        return ElasticGpuState.fromValue(this.elasticGpuState);
    }

    public String elasticGpuStateAsString() {
        return this.elasticGpuState;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuType());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuHealth());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticGpus)) {
            return false;
        }
        ElasticGpus other = (ElasticGpus)obj;
        return Objects.equals(this.elasticGpuId(), other.elasticGpuId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.elasticGpuType(), other.elasticGpuType()) && Objects.equals(this.elasticGpuHealth(), other.elasticGpuHealth()) && Objects.equals(this.elasticGpuStateAsString(), other.elasticGpuStateAsString()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ElasticGpus").add("ElasticGpuId", (Object)this.elasticGpuId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ElasticGpuType", (Object)this.elasticGpuType()).add("ElasticGpuHealth", (Object)this.elasticGpuHealth()).add("ElasticGpuState", (Object)this.elasticGpuStateAsString()).add("InstanceId", (Object)this.instanceId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticGpuId": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ElasticGpuType": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuType()));
            }
            case "ElasticGpuHealth": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuHealth()));
            }
            case "ElasticGpuState": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuStateAsString()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticGpus, T> g) {
        return obj -> g.apply((ElasticGpus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elasticGpuId;
        private String availabilityZone;
        private String elasticGpuType;
        private ElasticGpuHealth elasticGpuHealth;
        private String elasticGpuState;
        private String instanceId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticGpus model) {
            this.elasticGpuId(model.elasticGpuId);
            this.availabilityZone(model.availabilityZone);
            this.elasticGpuType(model.elasticGpuType);
            this.elasticGpuHealth(model.elasticGpuHealth);
            this.elasticGpuState(model.elasticGpuState);
            this.instanceId(model.instanceId);
            this.tags(model.tags);
        }

        public final String getElasticGpuId() {
            return this.elasticGpuId;
        }

        @Override
        public final Builder elasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
            return this;
        }

        public final void setElasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getElasticGpuType() {
            return this.elasticGpuType;
        }

        @Override
        public final Builder elasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
            return this;
        }

        public final void setElasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
        }

        public final ElasticGpuHealth.Builder getElasticGpuHealth() {
            return this.elasticGpuHealth != null ? this.elasticGpuHealth.toBuilder() : null;
        }

        @Override
        public final Builder elasticGpuHealth(ElasticGpuHealth elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth;
            return this;
        }

        public final void setElasticGpuHealth(ElasticGpuHealth.BuilderImpl elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth != null ? elasticGpuHealth.build() : null;
        }

        public final String getElasticGpuState() {
            return this.elasticGpuState;
        }

        @Override
        public final Builder elasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
            return this;
        }

        @Override
        public final Builder elasticGpuState(ElasticGpuState elasticGpuState) {
            this.elasticGpuState(elasticGpuState == null ? null : elasticGpuState.toString());
            return this;
        }

        public final void setElasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ElasticGpus build() {
            return new ElasticGpus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticGpus> {
        public Builder elasticGpuId(String var1);

        public Builder availabilityZone(String var1);

        public Builder elasticGpuType(String var1);

        public Builder elasticGpuHealth(ElasticGpuHealth var1);

        default public Builder elasticGpuHealth(Consumer<ElasticGpuHealth.Builder> elasticGpuHealth) {
            return this.elasticGpuHealth((ElasticGpuHealth)((ElasticGpuHealth.Builder)ElasticGpuHealth.builder().applyMutation(elasticGpuHealth)).build());
        }

        public Builder elasticGpuState(String var1);

        public Builder elasticGpuState(ElasticGpuState var1);

        public Builder instanceId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

