/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.RegionNameStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeRegionsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeRegionsRequest.getter(DescribeRegionsRequest::filters)).setter(DescribeRegionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionNames").getter(DescribeRegionsRequest.getter(DescribeRegionsRequest::regionNames)).setter(DescribeRegionsRequest.setter(Builder::regionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").unmarshallLocationName("RegionName").build(), ListTrait.builder().memberLocationName("RegionName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").unmarshallLocationName("RegionName").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllRegions").getter(DescribeRegionsRequest.getter(DescribeRegionsRequest::allRegions)).setter(DescribeRegionsRequest.setter(Builder::allRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllRegions").unmarshallLocationName("AllRegions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, REGION_NAMES_FIELD, ALL_REGIONS_FIELD));
    private final List<Filter> filters;
    private final List<String> regionNames;
    private final Boolean allRegions;

    private DescribeRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.regionNames = builder.regionNames;
        this.allRegions = builder.allRegions;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public boolean hasRegionNames() {
        return this.regionNames != null && !(this.regionNames instanceof SdkAutoConstructList);
    }

    public List<String> regionNames() {
        return this.regionNames;
    }

    public Boolean allRegions() {
        return this.allRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionNames() ? this.regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allRegions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsRequest)) {
            return false;
        }
        DescribeRegionsRequest other = (DescribeRegionsRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasRegionNames() == other.hasRegionNames() && Objects.equals(this.regionNames(), other.regionNames()) && Objects.equals(this.allRegions(), other.allRegions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRegionsRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("RegionNames", this.hasRegionNames() ? this.regionNames() : null).add("AllRegions", (Object)this.allRegions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "RegionNames": {
                return Optional.ofNullable(clazz.cast(this.regionNames()));
            }
            case "AllRegions": {
                return Optional.ofNullable(clazz.cast(this.allRegions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegionsRequest, T> g) {
        return obj -> g.apply((DescribeRegionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean allRegions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionsRequest model) {
            super(model);
            this.filters(model.filters);
            this.regionNames(model.regionNames);
            this.allRegions(model.allRegions);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (this.filters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getRegionNames() {
            if (this.regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionNames;
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            this.regionNames = RegionNameStringListCopier.copy(regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String ... regionNames) {
            this.regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            this.regionNames = RegionNameStringListCopier.copy(regionNames);
        }

        public final Boolean getAllRegions() {
            return this.allRegions;
        }

        @Override
        public final Builder allRegions(Boolean allRegions) {
            this.allRegions = allRegions;
            return this;
        }

        public final void setAllRegions(Boolean allRegions) {
            this.allRegions = allRegions;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRegionsRequest build() {
            return new DescribeRegionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegionsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder regionNames(Collection<String> var1);

        public Builder regionNames(String ... var1);

        public Builder allRegions(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

