/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.MembershipType;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMulticastGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMulticastGroup> {
    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupIpAddress").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::groupIpAddress)).setter(TransitGatewayMulticastGroup.setter(Builder::groupIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress").unmarshallLocationName("groupIpAddress").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::transitGatewayAttachmentId)).setter(TransitGatewayMulticastGroup.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::subnetId)).setter(TransitGatewayMulticastGroup.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::resourceId)).setter(TransitGatewayMulticastGroup.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::resourceTypeAsString)).setter(TransitGatewayMulticastGroup.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::networkInterfaceId)).setter(TransitGatewayMulticastGroup.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<Boolean> GROUP_MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GroupMember").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::groupMember)).setter(TransitGatewayMulticastGroup.setter(Builder::groupMember)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMember").unmarshallLocationName("groupMember").build()}).build();
    private static final SdkField<Boolean> GROUP_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GroupSource").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::groupSource)).setter(TransitGatewayMulticastGroup.setter(Builder::groupSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSource").unmarshallLocationName("groupSource").build()}).build();
    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberType").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::memberTypeAsString)).setter(TransitGatewayMulticastGroup.setter(Builder::memberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType").unmarshallLocationName("memberType").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(TransitGatewayMulticastGroup.getter(TransitGatewayMulticastGroup::sourceTypeAsString)).setter(TransitGatewayMulticastGroup.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").unmarshallLocationName("sourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IP_ADDRESS_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, SUBNET_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, NETWORK_INTERFACE_ID_FIELD, GROUP_MEMBER_FIELD, GROUP_SOURCE_FIELD, MEMBER_TYPE_FIELD, SOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupIpAddress;
    private final String transitGatewayAttachmentId;
    private final String subnetId;
    private final String resourceId;
    private final String resourceType;
    private final String networkInterfaceId;
    private final Boolean groupMember;
    private final Boolean groupSource;
    private final String memberType;
    private final String sourceType;

    private TransitGatewayMulticastGroup(BuilderImpl builder) {
        this.groupIpAddress = builder.groupIpAddress;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.subnetId = builder.subnetId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.groupMember = builder.groupMember;
        this.groupSource = builder.groupSource;
        this.memberType = builder.memberType;
        this.sourceType = builder.sourceType;
    }

    public String groupIpAddress() {
        return this.groupIpAddress;
    }

    public String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Boolean groupMember() {
        return this.groupMember;
    }

    public Boolean groupSource() {
        return this.groupSource;
    }

    public MembershipType memberType() {
        return MembershipType.fromValue(this.memberType);
    }

    public String memberTypeAsString() {
        return this.memberType;
    }

    public MembershipType sourceType() {
        return MembershipType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupMember());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMulticastGroup)) {
            return false;
        }
        TransitGatewayMulticastGroup other = (TransitGatewayMulticastGroup)obj;
        return Objects.equals(this.groupIpAddress(), other.groupIpAddress()) && Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.groupMember(), other.groupMember()) && Objects.equals(this.groupSource(), other.groupSource()) && Objects.equals(this.memberTypeAsString(), other.memberTypeAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TransitGatewayMulticastGroup").add("GroupIpAddress", (Object)this.groupIpAddress()).add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("SubnetId", (Object)this.subnetId()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("GroupMember", (Object)this.groupMember()).add("GroupSource", (Object)this.groupSource()).add("MemberType", (Object)this.memberTypeAsString()).add("SourceType", (Object)this.sourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupIpAddress": {
                return Optional.ofNullable(clazz.cast(this.groupIpAddress()));
            }
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "GroupMember": {
                return Optional.ofNullable(clazz.cast(this.groupMember()));
            }
            case "GroupSource": {
                return Optional.ofNullable(clazz.cast(this.groupSource()));
            }
            case "MemberType": {
                return Optional.ofNullable(clazz.cast(this.memberTypeAsString()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMulticastGroup, T> g) {
        return obj -> g.apply((TransitGatewayMulticastGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupIpAddress;
        private String transitGatewayAttachmentId;
        private String subnetId;
        private String resourceId;
        private String resourceType;
        private String networkInterfaceId;
        private Boolean groupMember;
        private Boolean groupSource;
        private String memberType;
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMulticastGroup model) {
            this.groupIpAddress(model.groupIpAddress);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.subnetId(model.subnetId);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.networkInterfaceId(model.networkInterfaceId);
            this.groupMember(model.groupMember);
            this.groupSource(model.groupSource);
            this.memberType(model.memberType);
            this.sourceType(model.sourceType);
        }

        public final String getGroupIpAddress() {
            return this.groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Boolean getGroupMember() {
            return this.groupMember;
        }

        @Override
        public final Builder groupMember(Boolean groupMember) {
            this.groupMember = groupMember;
            return this;
        }

        public final void setGroupMember(Boolean groupMember) {
            this.groupMember = groupMember;
        }

        public final Boolean getGroupSource() {
            return this.groupSource;
        }

        @Override
        public final Builder groupSource(Boolean groupSource) {
            this.groupSource = groupSource;
            return this;
        }

        public final void setGroupSource(Boolean groupSource) {
            this.groupSource = groupSource;
        }

        public final String getMemberType() {
            return this.memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MembershipType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(MembershipType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public TransitGatewayMulticastGroup build() {
            return new TransitGatewayMulticastGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMulticastGroup> {
        public Builder groupIpAddress(String var1);

        public Builder transitGatewayAttachmentId(String var1);

        public Builder subnetId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);

        public Builder networkInterfaceId(String var1);

        public Builder groupMember(Boolean var1);

        public Builder groupSource(Boolean var1);

        public Builder memberType(String var1);

        public Builder memberType(MembershipType var1);

        public Builder sourceType(String var1);

        public Builder sourceType(MembershipType var1);
    }
}

