/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachNetworkInterfaceResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AttachNetworkInterfaceResponse> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(AttachNetworkInterfaceResponse.getter(AttachNetworkInterfaceResponse::attachmentId)).setter(AttachNetworkInterfaceResponse.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").unmarshallLocationName("attachmentId").build()}).build();
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(AttachNetworkInterfaceResponse.getter(AttachNetworkInterfaceResponse::networkCardIndex)).setter(AttachNetworkInterfaceResponse.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("networkCardIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, NETWORK_CARD_INDEX_FIELD));
    private final String attachmentId;
    private final Integer networkCardIndex;

    private AttachNetworkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.networkCardIndex = builder.networkCardIndex;
    }

    public String attachmentId() {
        return this.attachmentId;
    }

    public Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachNetworkInterfaceResponse)) {
            return false;
        }
        AttachNetworkInterfaceResponse other = (AttachNetworkInterfaceResponse)((Object)obj);
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.networkCardIndex(), other.networkCardIndex());
    }

    public String toString() {
        return ToString.builder((String)"AttachNetworkInterfaceResponse").add("AttachmentId", (Object)this.attachmentId()).add("NetworkCardIndex", (Object)this.networkCardIndex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachNetworkInterfaceResponse, T> g) {
        return obj -> g.apply((AttachNetworkInterfaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String attachmentId;
        private Integer networkCardIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachNetworkInterfaceResponse model) {
            super(model);
            this.attachmentId(model.attachmentId);
            this.networkCardIndex(model.networkCardIndex);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public AttachNetworkInterfaceResponse build() {
            return new AttachNetworkInterfaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachNetworkInterfaceResponse> {
        public Builder attachmentId(String var1);

        public Builder networkCardIndex(Integer var1);
    }
}

