/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.VolumeStatusAction;
import software.amazon.awssdk.services.ec2.model.VolumeStatusActionsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusAttachmentStatus;
import software.amazon.awssdk.services.ec2.model.VolumeStatusAttachmentStatusListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusEvent;
import software.amazon.awssdk.services.ec2.model.VolumeStatusEventsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeStatusItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeStatusItem> {
    private static final SdkField<List<VolumeStatusAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(VolumeStatusItem.getter(VolumeStatusItem::actions)).setter(VolumeStatusItem.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsSet").unmarshallLocationName("actionsSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeStatusAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(VolumeStatusItem.getter(VolumeStatusItem::availabilityZone)).setter(VolumeStatusItem.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(VolumeStatusItem.getter(VolumeStatusItem::outpostArn)).setter(VolumeStatusItem.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final SdkField<List<VolumeStatusEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(VolumeStatusItem.getter(VolumeStatusItem::events)).setter(VolumeStatusItem.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsSet").unmarshallLocationName("eventsSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeStatusEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(VolumeStatusItem.getter(VolumeStatusItem::volumeId)).setter(VolumeStatusItem.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").unmarshallLocationName("volumeId").build()}).build();
    private static final SdkField<VolumeStatusInfo> VOLUME_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VolumeStatus").getter(VolumeStatusItem.getter(VolumeStatusItem::volumeStatus)).setter(VolumeStatusItem.setter(Builder::volumeStatus)).constructor(VolumeStatusInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatus").unmarshallLocationName("volumeStatus").build()}).build();
    private static final SdkField<List<VolumeStatusAttachmentStatus>> ATTACHMENT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachmentStatuses").getter(VolumeStatusItem.getter(VolumeStatusItem::attachmentStatuses)).setter(VolumeStatusItem.setter(Builder::attachmentStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentStatuses").unmarshallLocationName("attachmentStatuses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeStatusAttachmentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, AVAILABILITY_ZONE_FIELD, OUTPOST_ARN_FIELD, EVENTS_FIELD, VOLUME_ID_FIELD, VOLUME_STATUS_FIELD, ATTACHMENT_STATUSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<VolumeStatusAction> actions;
    private final String availabilityZone;
    private final String outpostArn;
    private final List<VolumeStatusEvent> events;
    private final String volumeId;
    private final VolumeStatusInfo volumeStatus;
    private final List<VolumeStatusAttachmentStatus> attachmentStatuses;

    private VolumeStatusItem(BuilderImpl builder) {
        this.actions = builder.actions;
        this.availabilityZone = builder.availabilityZone;
        this.outpostArn = builder.outpostArn;
        this.events = builder.events;
        this.volumeId = builder.volumeId;
        this.volumeStatus = builder.volumeStatus;
        this.attachmentStatuses = builder.attachmentStatuses;
    }

    public boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public List<VolumeStatusAction> actions() {
        return this.actions;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String outpostArn() {
        return this.outpostArn;
    }

    public boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public List<VolumeStatusEvent> events() {
        return this.events;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public VolumeStatusInfo volumeStatus() {
        return this.volumeStatus;
    }

    public boolean hasAttachmentStatuses() {
        return this.attachmentStatuses != null && !(this.attachmentStatuses instanceof SdkAutoConstructList);
    }

    public List<VolumeStatusAttachmentStatus> attachmentStatuses() {
        return this.attachmentStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachmentStatuses() ? this.attachmentStatuses() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusItem)) {
            return false;
        }
        VolumeStatusItem other = (VolumeStatusItem)obj;
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.outpostArn(), other.outpostArn()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.volumeStatus(), other.volumeStatus()) && this.hasAttachmentStatuses() == other.hasAttachmentStatuses() && Objects.equals(this.attachmentStatuses(), other.attachmentStatuses());
    }

    public String toString() {
        return ToString.builder((String)"VolumeStatusItem").add("Actions", this.hasActions() ? this.actions() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("OutpostArn", (Object)this.outpostArn()).add("Events", this.hasEvents() ? this.events() : null).add("VolumeId", (Object)this.volumeId()).add("VolumeStatus", (Object)this.volumeStatus()).add("AttachmentStatuses", this.hasAttachmentStatuses() ? this.attachmentStatuses() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "VolumeStatus": {
                return Optional.ofNullable(clazz.cast(this.volumeStatus()));
            }
            case "AttachmentStatuses": {
                return Optional.ofNullable(clazz.cast(this.attachmentStatuses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusItem, T> g) {
        return obj -> g.apply((VolumeStatusItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<VolumeStatusAction> actions = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String outpostArn;
        private List<VolumeStatusEvent> events = DefaultSdkAutoConstructList.getInstance();
        private String volumeId;
        private VolumeStatusInfo volumeStatus;
        private List<VolumeStatusAttachmentStatus> attachmentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusItem model) {
            this.actions(model.actions);
            this.availabilityZone(model.availabilityZone);
            this.outpostArn(model.outpostArn);
            this.events(model.events);
            this.volumeId(model.volumeId);
            this.volumeStatus(model.volumeStatus);
            this.attachmentStatuses(model.attachmentStatuses);
        }

        public final Collection<VolumeStatusAction.Builder> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions != null ? (Collection)this.actions.stream().map(VolumeStatusAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VolumeStatusAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VolumeStatusAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (VolumeStatusAction)((VolumeStatusAction.Builder)VolumeStatusAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<VolumeStatusAction.BuilderImpl> actions) {
            this.actions = VolumeStatusActionsListCopier.copyFromBuilder(actions);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public final Collection<VolumeStatusEvent.Builder> getEvents() {
            if (this.events instanceof SdkAutoConstructList) {
                return null;
            }
            return this.events != null ? (Collection)this.events.stream().map(VolumeStatusEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(VolumeStatusEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<VolumeStatusEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (VolumeStatusEvent)((VolumeStatusEvent.Builder)VolumeStatusEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<VolumeStatusEvent.BuilderImpl> events) {
            this.events = VolumeStatusEventsListCopier.copyFromBuilder(events);
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final VolumeStatusInfo.Builder getVolumeStatus() {
            return this.volumeStatus != null ? this.volumeStatus.toBuilder() : null;
        }

        @Override
        public final Builder volumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        public final void setVolumeStatus(VolumeStatusInfo.BuilderImpl volumeStatus) {
            this.volumeStatus = volumeStatus != null ? volumeStatus.build() : null;
        }

        public final Collection<VolumeStatusAttachmentStatus.Builder> getAttachmentStatuses() {
            if (this.attachmentStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachmentStatuses != null ? (Collection)this.attachmentStatuses.stream().map(VolumeStatusAttachmentStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachmentStatuses(Collection<VolumeStatusAttachmentStatus> attachmentStatuses) {
            this.attachmentStatuses = VolumeStatusAttachmentStatusListCopier.copy(attachmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentStatuses(VolumeStatusAttachmentStatus ... attachmentStatuses) {
            this.attachmentStatuses(Arrays.asList(attachmentStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentStatuses(Consumer<VolumeStatusAttachmentStatus.Builder> ... attachmentStatuses) {
            this.attachmentStatuses(Stream.of(attachmentStatuses).map(c -> (VolumeStatusAttachmentStatus)((VolumeStatusAttachmentStatus.Builder)VolumeStatusAttachmentStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentStatuses(Collection<VolumeStatusAttachmentStatus.BuilderImpl> attachmentStatuses) {
            this.attachmentStatuses = VolumeStatusAttachmentStatusListCopier.copyFromBuilder(attachmentStatuses);
        }

        public VolumeStatusItem build() {
            return new VolumeStatusItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeStatusItem> {
        public Builder actions(Collection<VolumeStatusAction> var1);

        public Builder actions(VolumeStatusAction ... var1);

        public Builder actions(Consumer<VolumeStatusAction.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder outpostArn(String var1);

        public Builder events(Collection<VolumeStatusEvent> var1);

        public Builder events(VolumeStatusEvent ... var1);

        public Builder events(Consumer<VolumeStatusEvent.Builder> ... var1);

        public Builder volumeId(String var1);

        public Builder volumeStatus(VolumeStatusInfo var1);

        default public Builder volumeStatus(Consumer<VolumeStatusInfo.Builder> volumeStatus) {
            return this.volumeStatus((VolumeStatusInfo)((VolumeStatusInfo.Builder)VolumeStatusInfo.builder().applyMutation(volumeStatus)).build());
        }

        public Builder attachmentStatuses(Collection<VolumeStatusAttachmentStatus> var1);

        public Builder attachmentStatuses(VolumeStatusAttachmentStatus ... var1);

        public Builder attachmentStatuses(Consumer<VolumeStatusAttachmentStatus.Builder> ... var1);
    }
}

