/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorTarget;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorTargetSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrafficMirrorTargetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTrafficMirrorTargetsResponse> {
    private static final SdkField<List<TrafficMirrorTarget>> TRAFFIC_MIRROR_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrafficMirrorTargets").getter(DescribeTrafficMirrorTargetsResponse.getter(DescribeTrafficMirrorTargetsResponse::trafficMirrorTargets)).setter(DescribeTrafficMirrorTargetsResponse.setter(Builder::trafficMirrorTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetSet").unmarshallLocationName("trafficMirrorTargetSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficMirrorTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTrafficMirrorTargetsResponse.getter(DescribeTrafficMirrorTargetsResponse::nextToken)).setter(DescribeTrafficMirrorTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TrafficMirrorTarget> trafficMirrorTargets;
    private final String nextToken;

    private DescribeTrafficMirrorTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorTargets = builder.trafficMirrorTargets;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTrafficMirrorTargets() {
        return this.trafficMirrorTargets != null && !(this.trafficMirrorTargets instanceof SdkAutoConstructList);
    }

    public List<TrafficMirrorTarget> trafficMirrorTargets() {
        return this.trafficMirrorTargets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrafficMirrorTargets() ? this.trafficMirrorTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficMirrorTargetsResponse)) {
            return false;
        }
        DescribeTrafficMirrorTargetsResponse other = (DescribeTrafficMirrorTargetsResponse)((Object)obj);
        return this.hasTrafficMirrorTargets() == other.hasTrafficMirrorTargets() && Objects.equals(this.trafficMirrorTargets(), other.trafficMirrorTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrafficMirrorTargetsResponse").add("TrafficMirrorTargets", this.hasTrafficMirrorTargets() ? this.trafficMirrorTargets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorTargets": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorTargets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficMirrorTargetsResponse, T> g) {
        return obj -> g.apply((DescribeTrafficMirrorTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TrafficMirrorTarget> trafficMirrorTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficMirrorTargetsResponse model) {
            super(model);
            this.trafficMirrorTargets(model.trafficMirrorTargets);
            this.nextToken(model.nextToken);
        }

        public final Collection<TrafficMirrorTarget.Builder> getTrafficMirrorTargets() {
            if (this.trafficMirrorTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trafficMirrorTargets != null ? (Collection)this.trafficMirrorTargets.stream().map(TrafficMirrorTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficMirrorTargets(Collection<TrafficMirrorTarget> trafficMirrorTargets) {
            this.trafficMirrorTargets = TrafficMirrorTargetSetCopier.copy(trafficMirrorTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorTargets(TrafficMirrorTarget ... trafficMirrorTargets) {
            this.trafficMirrorTargets(Arrays.asList(trafficMirrorTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorTargets(Consumer<TrafficMirrorTarget.Builder> ... trafficMirrorTargets) {
            this.trafficMirrorTargets(Stream.of(trafficMirrorTargets).map(c -> (TrafficMirrorTarget)((TrafficMirrorTarget.Builder)TrafficMirrorTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrafficMirrorTargets(Collection<TrafficMirrorTarget.BuilderImpl> trafficMirrorTargets) {
            this.trafficMirrorTargets = TrafficMirrorTargetSetCopier.copyFromBuilder(trafficMirrorTargets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTrafficMirrorTargetsResponse build() {
            return new DescribeTrafficMirrorTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrafficMirrorTargetsResponse> {
        public Builder trafficMirrorTargets(Collection<TrafficMirrorTarget> var1);

        public Builder trafficMirrorTargets(TrafficMirrorTarget ... var1);

        public Builder trafficMirrorTargets(Consumer<TrafficMirrorTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

