/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Ipv6Pool;
import software.amazon.awssdk.services.ec2.model.Ipv6PoolSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpv6PoolsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpv6PoolsResponse> {
    private static final SdkField<List<Ipv6Pool>> IPV6_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Pools").getter(DescribeIpv6PoolsResponse.getter(DescribeIpv6PoolsResponse::ipv6Pools)).setter(DescribeIpv6PoolsResponse.setter(Builder::ipv6Pools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PoolSet").unmarshallLocationName("ipv6PoolSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6Pool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpv6PoolsResponse.getter(DescribeIpv6PoolsResponse::nextToken)).setter(DescribeIpv6PoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Ipv6Pool> ipv6Pools;
    private final String nextToken;

    private DescribeIpv6PoolsResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6Pools = builder.ipv6Pools;
        this.nextToken = builder.nextToken;
    }

    public boolean hasIpv6Pools() {
        return this.ipv6Pools != null && !(this.ipv6Pools instanceof SdkAutoConstructList);
    }

    public List<Ipv6Pool> ipv6Pools() {
        return this.ipv6Pools;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Pools() ? this.ipv6Pools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpv6PoolsResponse)) {
            return false;
        }
        DescribeIpv6PoolsResponse other = (DescribeIpv6PoolsResponse)((Object)obj);
        return this.hasIpv6Pools() == other.hasIpv6Pools() && Objects.equals(this.ipv6Pools(), other.ipv6Pools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIpv6PoolsResponse").add("Ipv6Pools", this.hasIpv6Pools() ? this.ipv6Pools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6Pools": {
                return Optional.ofNullable(clazz.cast(this.ipv6Pools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpv6PoolsResponse, T> g) {
        return obj -> g.apply((DescribeIpv6PoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Ipv6Pool> ipv6Pools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpv6PoolsResponse model) {
            super(model);
            this.ipv6Pools(model.ipv6Pools);
            this.nextToken(model.nextToken);
        }

        public final Collection<Ipv6Pool.Builder> getIpv6Pools() {
            if (this.ipv6Pools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv6Pools != null ? (Collection)this.ipv6Pools.stream().map(Ipv6Pool::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Pools(Collection<Ipv6Pool> ipv6Pools) {
            this.ipv6Pools = Ipv6PoolSetCopier.copy(ipv6Pools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Pools(Ipv6Pool ... ipv6Pools) {
            this.ipv6Pools(Arrays.asList(ipv6Pools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Pools(Consumer<Ipv6Pool.Builder> ... ipv6Pools) {
            this.ipv6Pools(Stream.of(ipv6Pools).map(c -> (Ipv6Pool)((Ipv6Pool.Builder)Ipv6Pool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Pools(Collection<Ipv6Pool.BuilderImpl> ipv6Pools) {
            this.ipv6Pools = Ipv6PoolSetCopier.copyFromBuilder(ipv6Pools);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeIpv6PoolsResponse build() {
            return new DescribeIpv6PoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpv6PoolsResponse> {
        public Builder ipv6Pools(Collection<Ipv6Pool> var1);

        public Builder ipv6Pools(Ipv6Pool ... var1);

        public Builder ipv6Pools(Consumer<Ipv6Pool.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

