/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientVpnConnection;
import software.amazon.awssdk.services.ec2.model.ClientVpnConnectionSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClientVpnConnectionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeClientVpnConnectionsResponse> {
    private static final SdkField<List<ClientVpnConnection>> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Connections").getter(DescribeClientVpnConnectionsResponse.getter(DescribeClientVpnConnectionsResponse::connections)).setter(DescribeClientVpnConnectionsResponse.setter(Builder::connections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").unmarshallLocationName("connections").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientVpnConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeClientVpnConnectionsResponse.getter(DescribeClientVpnConnectionsResponse::nextToken)).setter(DescribeClientVpnConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ClientVpnConnection> connections;
    private final String nextToken;

    private DescribeClientVpnConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.connections = builder.connections;
        this.nextToken = builder.nextToken;
    }

    public boolean hasConnections() {
        return this.connections != null && !(this.connections instanceof SdkAutoConstructList);
    }

    public List<ClientVpnConnection> connections() {
        return this.connections;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnections() ? this.connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnConnectionsResponse)) {
            return false;
        }
        DescribeClientVpnConnectionsResponse other = (DescribeClientVpnConnectionsResponse)((Object)obj);
        return this.hasConnections() == other.hasConnections() && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClientVpnConnectionsResponse").add("Connections", this.hasConnections() ? this.connections() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnConnectionsResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ClientVpnConnection> connections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnConnectionsResponse model) {
            super(model);
            this.connections(model.connections);
            this.nextToken(model.nextToken);
        }

        public final Collection<ClientVpnConnection.Builder> getConnections() {
            if (this.connections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connections != null ? (Collection)this.connections.stream().map(ClientVpnConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connections(Collection<ClientVpnConnection> connections) {
            this.connections = ClientVpnConnectionSetCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(ClientVpnConnection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<ClientVpnConnection.Builder> ... connections) {
            this.connections(Stream.of(connections).map(c -> (ClientVpnConnection)((ClientVpnConnection.Builder)ClientVpnConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnections(Collection<ClientVpnConnection.BuilderImpl> connections) {
            this.connections = ClientVpnConnectionSetCopier.copyFromBuilder(connections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeClientVpnConnectionsResponse build() {
            return new DescribeClientVpnConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClientVpnConnectionsResponse> {
        public Builder connections(Collection<ClientVpnConnection> var1);

        public Builder connections(ClientVpnConnection ... var1);

        public Builder connections(Consumer<ClientVpnConnection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

