/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceHealthStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveInstance> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ActiveInstance.getter(ActiveInstance::instanceId)).setter(ActiveInstance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ActiveInstance.getter(ActiveInstance::instanceType)).setter(ActiveInstance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotInstanceRequestId").getter(ActiveInstance.getter(ActiveInstance::spotInstanceRequestId)).setter(ActiveInstance.setter(Builder::spotInstanceRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId").unmarshallLocationName("spotInstanceRequestId").build()}).build();
    private static final SdkField<String> INSTANCE_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceHealth").getter(ActiveInstance.getter(ActiveInstance::instanceHealthAsString)).setter(ActiveInstance.setter(Builder::instanceHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceHealth").unmarshallLocationName("instanceHealth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, SPOT_INSTANCE_REQUEST_ID_FIELD, INSTANCE_HEALTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String instanceType;
    private final String spotInstanceRequestId;
    private final String instanceHealth;

    private ActiveInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.instanceHealth = builder.instanceHealth;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public InstanceHealthStatus instanceHealth() {
        return InstanceHealthStatus.fromValue(this.instanceHealth);
    }

    public String instanceHealthAsString() {
        return this.instanceHealth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceHealthAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveInstance)) {
            return false;
        }
        ActiveInstance other = (ActiveInstance)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.spotInstanceRequestId(), other.spotInstanceRequestId()) && Objects.equals(this.instanceHealthAsString(), other.instanceHealthAsString());
    }

    public String toString() {
        return ToString.builder((String)"ActiveInstance").add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceType()).add("SpotInstanceRequestId", (Object)this.spotInstanceRequestId()).add("InstanceHealth", (Object)this.instanceHealthAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "SpotInstanceRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestId()));
            }
            case "InstanceHealth": {
                return Optional.ofNullable(clazz.cast(this.instanceHealthAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveInstance, T> g) {
        return obj -> g.apply((ActiveInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String instanceType;
        private String spotInstanceRequestId;
        private String instanceHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveInstance model) {
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.instanceHealth(model.instanceHealth);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getInstanceHealth() {
            return this.instanceHealth;
        }

        @Override
        public final Builder instanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
            return this;
        }

        @Override
        public final Builder instanceHealth(InstanceHealthStatus instanceHealth) {
            this.instanceHealth(instanceHealth == null ? null : instanceHealth.toString());
            return this;
        }

        public final void setInstanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
        }

        public ActiveInstance build() {
            return new ActiveInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveInstance> {
        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder spotInstanceRequestId(String var1);

        public Builder instanceHealth(String var1);

        public Builder instanceHealth(InstanceHealthStatus var1);
    }
}

