/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ExportTask;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceExportTaskResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateInstanceExportTaskResponse> {
    private static final SdkField<ExportTask> EXPORT_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportTask").getter(CreateInstanceExportTaskResponse.getter(CreateInstanceExportTaskResponse::exportTask)).setter(CreateInstanceExportTaskResponse.setter(Builder::exportTask)).constructor(ExportTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTask").unmarshallLocationName("exportTask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_FIELD));
    private final ExportTask exportTask;

    private CreateInstanceExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.exportTask = builder.exportTask;
    }

    public ExportTask exportTask() {
        return this.exportTask;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTask());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskResponse)) {
            return false;
        }
        CreateInstanceExportTaskResponse other = (CreateInstanceExportTaskResponse)((Object)obj);
        return Objects.equals(this.exportTask(), other.exportTask());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstanceExportTaskResponse").add("ExportTask", (Object)this.exportTask()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportTask": {
                return Optional.ofNullable(clazz.cast(this.exportTask()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceExportTaskResponse, T> g) {
        return obj -> g.apply((CreateInstanceExportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private ExportTask exportTask;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskResponse model) {
            super(model);
            this.exportTask(model.exportTask);
        }

        public final ExportTask.Builder getExportTask() {
            return this.exportTask != null ? this.exportTask.toBuilder() : null;
        }

        @Override
        public final Builder exportTask(ExportTask exportTask) {
            this.exportTask = exportTask;
            return this;
        }

        public final void setExportTask(ExportTask.BuilderImpl exportTask) {
            this.exportTask = exportTask != null ? exportTask.build() : null;
        }

        @Override
        public CreateInstanceExportTaskResponse build() {
            return new CreateInstanceExportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceExportTaskResponse> {
        public Builder exportTask(ExportTask var1);

        default public Builder exportTask(Consumer<ExportTask.Builder> exportTask) {
            return this.exportTask((ExportTask)((ExportTask.Builder)ExportTask.builder().applyMutation(exportTask)).build());
        }
    }
}

